/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.myfaces.component.html.ext;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import org.apache.myfaces.component.AttachedDeltaWrapper;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.component.UIComponent;


// Generated from class org.apache.myfaces.component.html.ext.AbstractHtmlSelectOneRadio.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class HtmlSelectOneRadio extends org.apache.myfaces.component.html.ext.AbstractHtmlSelectOneRadio
{

    static public final String COMPONENT_FAMILY =
        "javax.faces.SelectOne";
    static public final String COMPONENT_TYPE =
        "org.apache.myfaces.HtmlSelectOneRadio";
    static public final String DEFAULT_RENDERER_TYPE = 
        "org.apache.myfaces.Radio";


    public HtmlSelectOneRadio()
    {
        setRendererType("org.apache.myfaces.Radio");
    }

    public String getFamily()
    {
        return COMPONENT_FAMILY;
    }



    
    // Property: displayValueOnly
    public Boolean getDisplayValueOnly()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.displayValueOnly);
    }
    
    public void setDisplayValueOnly(Boolean displayValueOnly)
    {
        getStateHelper().put(PropertyKeys.displayValueOnly, displayValueOnly ); 
    }    
    // Property: displayValueOnlyStyle
    public String getDisplayValueOnlyStyle()
    {
        return (String) getStateHelper().eval(PropertyKeys.displayValueOnlyStyle);
    }
    
    public void setDisplayValueOnlyStyle(String displayValueOnlyStyle)
    {
        getStateHelper().put(PropertyKeys.displayValueOnlyStyle, displayValueOnlyStyle ); 
    }    
    // Property: displayValueOnlyStyleClass
    public String getDisplayValueOnlyStyleClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.displayValueOnlyStyleClass);
    }
    
    public void setDisplayValueOnlyStyleClass(String displayValueOnlyStyleClass)
    {
        getStateHelper().put(PropertyKeys.displayValueOnlyStyleClass, displayValueOnlyStyleClass ); 
    }    
    // Property: escape
    public boolean isEscape()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.escape, true);
    }
    
    public void setEscape(boolean escape)
    {
        getStateHelper().put(PropertyKeys.escape, escape ); 
    }    
    // Property: alt
    public String getAlt()
    {
        return (String) getStateHelper().eval(PropertyKeys.alt);
    }
    
    public void setAlt(String alt)
    {
        getStateHelper().put(PropertyKeys.alt, alt ); 
    }    
    // Property: datafld
    public String getDatafld()
    {
        return (String) getStateHelper().eval(PropertyKeys.datafld);
    }
    
    public void setDatafld(String datafld)
    {
        getStateHelper().put(PropertyKeys.datafld, datafld ); 
    }    
    // Property: datasrc
    public String getDatasrc()
    {
        return (String) getStateHelper().eval(PropertyKeys.datasrc);
    }
    
    public void setDatasrc(String datasrc)
    {
        getStateHelper().put(PropertyKeys.datasrc, datasrc ); 
    }    
    // Property: dataformatas
    public String getDataformatas()
    {
        return (String) getStateHelper().eval(PropertyKeys.dataformatas);
    }
    
    public void setDataformatas(String dataformatas)
    {
        getStateHelper().put(PropertyKeys.dataformatas, dataformatas ); 
    }    
    // Property: enabledOnUserRole
    public String getEnabledOnUserRole()
    {
        return (String) getStateHelper().eval(PropertyKeys.enabledOnUserRole);
    }
    
    public void setEnabledOnUserRole(String enabledOnUserRole)
    {
        getStateHelper().put(PropertyKeys.enabledOnUserRole, enabledOnUserRole ); 
    }    
    // Property: visibleOnUserRole
    public String getVisibleOnUserRole()
    {
        return (String) getStateHelper().eval(PropertyKeys.visibleOnUserRole);
    }
    
    public void setVisibleOnUserRole(String visibleOnUserRole)
    {
        getStateHelper().put(PropertyKeys.visibleOnUserRole, visibleOnUserRole ); 
    }    
    // Property: forceId
    public boolean isForceId()
    {
        Object value = getStateHelper().get(PropertyKeys.forceId);
        if (value != null)
        {
            return (Boolean) value;        
        }
        return false;        
    }
    
    public void setForceId(boolean forceId)
    {
        getStateHelper().put(PropertyKeys.forceId, forceId ); 
    }    
    // Property: forceIdIndex
    public boolean isForceIdIndex()
    {
        Object value = getStateHelper().get(PropertyKeys.forceIdIndex);
        if (value != null)
        {
            return (Boolean) value;        
        }
        return true;        
    }
    
    public void setForceIdIndex(boolean forceIdIndex)
    {
        getStateHelper().put(PropertyKeys.forceIdIndex, forceIdIndex ); 
    }    

    protected enum PropertyKeys
    {
         displayValueOnly
        , displayValueOnlyStyle
        , displayValueOnlyStyleClass
        , escape
        , alt
        , datafld
        , datasrc
        , dataformatas
        , enabledOnUserRole
        , visibleOnUserRole
        , forceId
        , forceIdIndex
    }

 }
