/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.myfaces.custom.calendar;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import org.apache.myfaces.component.AttachedDeltaWrapper;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import org.apache.myfaces.custom.calendar.DateBusinessConverter;
import javax.faces.component.UIComponent;


// Generated from class org.apache.myfaces.custom.calendar.AbstractHtmlInputCalendar.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class HtmlInputCalendar extends org.apache.myfaces.custom.calendar.AbstractHtmlInputCalendar
{

    static public final String COMPONENT_FAMILY =
        "javax.faces.Input";
    static public final String COMPONENT_TYPE =
        "org.apache.myfaces.HtmlInputCalendar";
    static public final String DEFAULT_RENDERER_TYPE = 
        "org.apache.myfaces.Calendar";


    public HtmlInputCalendar()
    {
        setRendererType("org.apache.myfaces.Calendar");
    }

    public String getFamily()
    {
        return COMPONENT_FAMILY;
    }



    
    // Property: dateBusinessConverter
    public DateBusinessConverter getDateBusinessConverter()
    {
        return (DateBusinessConverter) getStateHelper().eval(PropertyKeys.dateBusinessConverter);
    }
    
    public void setDateBusinessConverter(DateBusinessConverter dateBusinessConverter)
    {
        getStateHelper().put(PropertyKeys.dateBusinessConverter, dateBusinessConverter ); 
    }    
    // Property: monthYearRowClass
    public String getMonthYearRowClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.monthYearRowClass);
    }
    
    public void setMonthYearRowClass(String monthYearRowClass)
    {
        getStateHelper().put(PropertyKeys.monthYearRowClass, monthYearRowClass ); 
    }    
    // Property: weekRowClass
    public String getWeekRowClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.weekRowClass);
    }
    
    public void setWeekRowClass(String weekRowClass)
    {
        getStateHelper().put(PropertyKeys.weekRowClass, weekRowClass ); 
    }    
    // Property: dayCellClass
    public String getDayCellClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.dayCellClass);
    }
    
    public void setDayCellClass(String dayCellClass)
    {
        getStateHelper().put(PropertyKeys.dayCellClass, dayCellClass ); 
    }    
    // Property: currentDayCellClass
    public String getCurrentDayCellClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.currentDayCellClass);
    }
    
    public void setCurrentDayCellClass(String currentDayCellClass)
    {
        getStateHelper().put(PropertyKeys.currentDayCellClass, currentDayCellClass ); 
    }    
    // Property: popupLeft
    public boolean isPopupLeft()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.popupLeft, false);
    }
    
    public void setPopupLeft(boolean popupLeft)
    {
        getStateHelper().put(PropertyKeys.popupLeft, popupLeft ); 
    }    
    // Property: renderAsPopup
    public boolean isRenderAsPopup()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.renderAsPopup, false);
    }
    
    public void setRenderAsPopup(boolean renderAsPopup)
    {
        getStateHelper().put(PropertyKeys.renderAsPopup, renderAsPopup ); 
    }    
    // Property: addResources
    public boolean isAddResources()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.addResources, true);
    }
    
    public void setAddResources(boolean addResources)
    {
        getStateHelper().put(PropertyKeys.addResources, addResources ); 
    }    
    // Property: popupButtonString
    public String getPopupButtonString()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupButtonString);
    }
    
    public void setPopupButtonString(String popupButtonString)
    {
        getStateHelper().put(PropertyKeys.popupButtonString, popupButtonString ); 
    }    
    // Property: popupButtonStyle
    public String getPopupButtonStyle()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupButtonStyle);
    }
    
    public void setPopupButtonStyle(String popupButtonStyle)
    {
        getStateHelper().put(PropertyKeys.popupButtonStyle, popupButtonStyle ); 
    }    
    // Property: popupButtonStyleClass
    public String getPopupButtonStyleClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupButtonStyleClass);
    }
    
    public void setPopupButtonStyleClass(String popupButtonStyleClass)
    {
        getStateHelper().put(PropertyKeys.popupButtonStyleClass, popupButtonStyleClass ); 
    }    
    // Property: renderPopupButtonAsImage
    public boolean isRenderPopupButtonAsImage()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.renderPopupButtonAsImage, false);
    }
    
    public void setRenderPopupButtonAsImage(boolean renderPopupButtonAsImage)
    {
        getStateHelper().put(PropertyKeys.renderPopupButtonAsImage, renderPopupButtonAsImage ); 
    }    
    // Property: popupDateFormat
    public String getPopupDateFormat()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupDateFormat);
    }
    
    public void setPopupDateFormat(String popupDateFormat)
    {
        getStateHelper().put(PropertyKeys.popupDateFormat, popupDateFormat ); 
    }    
    // Property: popupGotoString
    public String getPopupGotoString()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupGotoString);
    }
    
    public void setPopupGotoString(String popupGotoString)
    {
        getStateHelper().put(PropertyKeys.popupGotoString, popupGotoString ); 
    }    
    // Property: popupTodayString
    public String getPopupTodayString()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupTodayString);
    }
    
    public void setPopupTodayString(String popupTodayString)
    {
        getStateHelper().put(PropertyKeys.popupTodayString, popupTodayString ); 
    }    
    // Property: popupTodayDateFormat
    public String getPopupTodayDateFormat()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupTodayDateFormat);
    }
    
    public void setPopupTodayDateFormat(String popupTodayDateFormat)
    {
        getStateHelper().put(PropertyKeys.popupTodayDateFormat, popupTodayDateFormat ); 
    }    
    // Property: popupWeekString
    public String getPopupWeekString()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupWeekString);
    }
    
    public void setPopupWeekString(String popupWeekString)
    {
        getStateHelper().put(PropertyKeys.popupWeekString, popupWeekString ); 
    }    
    // Property: popupScrollLeftMessage
    public String getPopupScrollLeftMessage()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupScrollLeftMessage);
    }
    
    public void setPopupScrollLeftMessage(String popupScrollLeftMessage)
    {
        getStateHelper().put(PropertyKeys.popupScrollLeftMessage, popupScrollLeftMessage ); 
    }    
    // Property: popupScrollRightMessage
    public String getPopupScrollRightMessage()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupScrollRightMessage);
    }
    
    public void setPopupScrollRightMessage(String popupScrollRightMessage)
    {
        getStateHelper().put(PropertyKeys.popupScrollRightMessage, popupScrollRightMessage ); 
    }    
    // Property: popupSelectMonthMessage
    public String getPopupSelectMonthMessage()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupSelectMonthMessage);
    }
    
    public void setPopupSelectMonthMessage(String popupSelectMonthMessage)
    {
        getStateHelper().put(PropertyKeys.popupSelectMonthMessage, popupSelectMonthMessage ); 
    }    
    // Property: popupSelectYearMessage
    public String getPopupSelectYearMessage()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupSelectYearMessage);
    }
    
    public void setPopupSelectYearMessage(String popupSelectYearMessage)
    {
        getStateHelper().put(PropertyKeys.popupSelectYearMessage, popupSelectYearMessage ); 
    }    
    // Property: popupSelectDateMessage
    public String getPopupSelectDateMessage()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupSelectDateMessage);
    }
    
    public void setPopupSelectDateMessage(String popupSelectDateMessage)
    {
        getStateHelper().put(PropertyKeys.popupSelectDateMessage, popupSelectDateMessage ); 
    }    
    // Property: popupTheme
    public String getPopupTheme()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupTheme);
    }
    
    public void setPopupTheme(String popupTheme)
    {
        getStateHelper().put(PropertyKeys.popupTheme, popupTheme ); 
    }    
    // Property: popupButtonImageUrl
    public String getPopupButtonImageUrl()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupButtonImageUrl);
    }
    
    public void setPopupButtonImageUrl(String popupButtonImageUrl)
    {
        getStateHelper().put(PropertyKeys.popupButtonImageUrl, popupButtonImageUrl ); 
    }    
    // Property: helpText
    public String getHelpText()
    {
        return (String) getStateHelper().eval(PropertyKeys.helpText);
    }
    
    public void setHelpText(String helpText)
    {
        getStateHelper().put(PropertyKeys.helpText, helpText ); 
    }    
    // Property: popupSelectMode
    public String getPopupSelectMode()
    {
        return (String) getStateHelper().eval(PropertyKeys.popupSelectMode, "day");
    }
    
    public void setPopupSelectMode(String popupSelectMode)
    {
        getStateHelper().put(PropertyKeys.popupSelectMode, popupSelectMode ); 
    }    
    // Property: align
    public String getAlign()
    {
        return (String) getStateHelper().eval(PropertyKeys.align);
    }
    
    public void setAlign(String align)
    {
        getStateHelper().put(PropertyKeys.align, align ); 
    }    
    // Property: javascriptLocation
    public String getJavascriptLocation()
    {
        return (String) getStateHelper().eval(PropertyKeys.javascriptLocation);
    }
    
    public void setJavascriptLocation(String javascriptLocation)
    {
        getStateHelper().put(PropertyKeys.javascriptLocation, javascriptLocation ); 
    }    
    // Property: imageLocation
    public String getImageLocation()
    {
        return (String) getStateHelper().eval(PropertyKeys.imageLocation);
    }
    
    public void setImageLocation(String imageLocation)
    {
        getStateHelper().put(PropertyKeys.imageLocation, imageLocation ); 
    }    
    // Property: styleLocation
    public String getStyleLocation()
    {
        return (String) getStateHelper().eval(PropertyKeys.styleLocation);
    }
    
    public void setStyleLocation(String styleLocation)
    {
        getStateHelper().put(PropertyKeys.styleLocation, styleLocation ); 
    }    
    // Property: enabledOnUserRole
    public String getEnabledOnUserRole()
    {
        return (String) getStateHelper().eval(PropertyKeys.enabledOnUserRole);
    }
    
    public void setEnabledOnUserRole(String enabledOnUserRole)
    {
        getStateHelper().put(PropertyKeys.enabledOnUserRole, enabledOnUserRole ); 
    }    
    // Property: visibleOnUserRole
    public String getVisibleOnUserRole()
    {
        return (String) getStateHelper().eval(PropertyKeys.visibleOnUserRole);
    }
    
    public void setVisibleOnUserRole(String visibleOnUserRole)
    {
        getStateHelper().put(PropertyKeys.visibleOnUserRole, visibleOnUserRole ); 
    }    
    // Property: javascriptLibrary
    public String getJavascriptLibrary()
    {
        return (String) getStateHelper().eval(PropertyKeys.javascriptLibrary);
    }
    
    public void setJavascriptLibrary(String javascriptLibrary)
    {
        getStateHelper().put(PropertyKeys.javascriptLibrary, javascriptLibrary ); 
    }    
    // Property: imageLibrary
    public String getImageLibrary()
    {
        return (String) getStateHelper().eval(PropertyKeys.imageLibrary);
    }
    
    public void setImageLibrary(String imageLibrary)
    {
        getStateHelper().put(PropertyKeys.imageLibrary, imageLibrary ); 
    }    
    // Property: styleLibrary
    public String getStyleLibrary()
    {
        return (String) getStateHelper().eval(PropertyKeys.styleLibrary);
    }
    
    public void setStyleLibrary(String styleLibrary)
    {
        getStateHelper().put(PropertyKeys.styleLibrary, styleLibrary ); 
    }    

    protected enum PropertyKeys
    {
         dateBusinessConverter
        , monthYearRowClass
        , weekRowClass
        , dayCellClass
        , currentDayCellClass
        , popupLeft
        , renderAsPopup
        , addResources
        , popupButtonString
        , popupButtonStyle
        , popupButtonStyleClass
        , renderPopupButtonAsImage
        , popupDateFormat
        , popupGotoString
        , popupTodayString
        , popupTodayDateFormat
        , popupWeekString
        , popupScrollLeftMessage
        , popupScrollRightMessage
        , popupSelectMonthMessage
        , popupSelectYearMessage
        , popupSelectDateMessage
        , popupTheme
        , popupButtonImageUrl
        , helpText
        , popupSelectMode
        , align
        , javascriptLocation
        , imageLocation
        , styleLocation
        , enabledOnUserRole
        , visibleOnUserRole
        , javascriptLibrary
        , imageLibrary
        , styleLibrary
    }

 }
