/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.myfaces.custom.inputTextHelp;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import org.apache.myfaces.component.AttachedDeltaWrapper;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.component.UIComponent;


// Generated from class org.apache.myfaces.custom.inputTextHelp.AbstractHtmlInputTextHelp.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class HtmlInputTextHelp extends org.apache.myfaces.custom.inputTextHelp.AbstractHtmlInputTextHelp
{

    static public final String COMPONENT_FAMILY =
        "javax.faces.Input";
    static public final String COMPONENT_TYPE =
        "org.apache.myfaces.HtmlInputTextHelp";
    static public final String DEFAULT_RENDERER_TYPE = 
        "org.apache.myfaces.TextHelp";


    public HtmlInputTextHelp()
    {
        setRendererType("org.apache.myfaces.TextHelp");
    }

    public String getFamily()
    {
        return COMPONENT_FAMILY;
    }



    
    // Property: helpText
    public String getHelpText()
    {
        return (String) getStateHelper().eval(PropertyKeys.helpText);
    }
    
    public void setHelpText(String helpText)
    {
        getStateHelper().put(PropertyKeys.helpText, helpText ); 
    }    
    // Property: selectText
    public boolean isSelectText()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.selectText, false);
    }
    
    public void setSelectText(boolean selectText)
    {
        getStateHelper().put(PropertyKeys.selectText, selectText ); 
    }    

    protected enum PropertyKeys
    {
         helpText
        , selectText
    }

 }
