/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.renderkit.html;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.shared_tomahawk.component.EscapeCapable;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.ResourceUtils;

public class HtmlTextRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlTextRendererBase.class.getName());
    private static final String AUTOCOMPLETE_VALUE_OFF = "off";

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, null);
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)component).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        if (component instanceof UIInput) {
            this.renderInput(facesContext, component);
        } else if (component instanceof UIOutput) {
            this.renderOutput(facesContext, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected void renderOutput(FacesContext facesContext, UIComponent component) throws IOException {
        String text = RendererUtils.getStringValue(facesContext, component);
        if (log.isLoggable(Level.FINE)) {
            log.fine("renderOutput '" + text + "'");
        }
        boolean escape = component instanceof HtmlOutputText || component instanceof EscapeCapable ? ((HtmlOutputText)component).isEscape() : RendererUtils.getBooleanAttribute(component, "escape", true);
        HtmlTextRendererBase.renderOutputText(facesContext, component, text, escape);
    }

    public static void renderOutputText(FacesContext facesContext, UIComponent component, String text, boolean escape) throws IOException {
        if (text != null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            boolean span = false;
            if (component.getId() != null && !component.getId().startsWith("j_id")) {
                span = true;
                writer.startElement("span", component);
                HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else {
                span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, component, "span", HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            }
            if (escape) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("renderOutputText writing '" + text + "'");
                }
                writer.writeText((Object)text, "value");
            } else {
                writer.write(text);
            }
            if (span) {
                writer.endElement("span");
            }
        }
    }

    protected void renderInput(FacesContext facesContext, UIComponent component) throws IOException {
        this.renderInputBegin(facesContext, component);
        this.renderInputEnd(facesContext, component);
    }

    protected void renderInputBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        String value = RendererUtils.getStringValue(facesContext, component);
        if (log.isLoggable(Level.FINE)) {
            log.fine("renderInput '" + value + "'");
        }
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        String inputHtmlType = this.getInputHtmlType(component);
        writer.writeAttribute("type", (Object)inputHtmlType, null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, "value");
        }
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
            behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
            HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, component, behaviors);
            HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, component, behaviors);
            HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, component, behaviors);
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        }
        if (this.isDisabled(facesContext, component)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        if (this.isAutocompleteOff(facesContext, component)) {
            writer.writeAttribute("autocomplete", (Object)AUTOCOMPLETE_VALUE_OFF, "autocomplete");
        }
    }

    protected void renderInputEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("input");
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent component) {
        if (component instanceof HtmlInputText) {
            return ((HtmlInputText)component).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(component, "disabled", false);
    }

    protected boolean isAutocompleteOff(FacesContext facesContext, UIComponent component) {
        String autocomplete;
        if (component instanceof HtmlInputText && (autocomplete = ((HtmlInputText)component).getAutocomplete()) != null) {
            return autocomplete.equals(AUTOCOMPLETE_VALUE_OFF);
        }
        return false;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (component instanceof UIInput) {
            HtmlRendererUtils.decodeUIInput(facesContext, component);
            if (component instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(component)) {
                HtmlRendererUtils.decodeClientBehaviors(facesContext, component);
            }
        } else if (!(component instanceof UIOutput)) {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, component, UIOutput.class);
        return RendererUtils.getConvertedUIOutputValue(facesContext, (UIOutput)component, submittedValue);
    }

    protected String getInputHtmlType(UIComponent component) {
        return "text";
    }
}

