/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.ResourceUtils;

public class HtmlTextareaRendererBase
extends HtmlRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIInput.class);
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        this.encodeTextArea(facesContext, uiComponent);
    }

    protected void encodeTextArea(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.renderTextAreaBegin(facesContext, uiComponent);
        this.renderTextAreaEnd(facesContext, uiComponent);
    }

    protected void renderTextAreaBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("textarea", uiComponent);
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
            behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors();
            if (!behaviors.isEmpty()) {
                HtmlRendererUtils.writeIdAndName(writer, uiComponent, facesContext);
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
                writer.writeAttribute("name", (Object)uiComponent.getClientId(facesContext), null);
            }
            HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.TEXTAREA_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            writer.writeAttribute("name", (Object)uiComponent.getClientId(facesContext), null);
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.TEXTAREA_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        }
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        String strValue = RendererUtils.getStringValue(facesContext, uiComponent);
        writer.writeText((Object)strValue, "value");
    }

    protected void renderTextAreaEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        facesContext.getResponseWriter().endElement("textarea");
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlInputTextarea) {
            return ((HtmlInputTextarea)uiComponent).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity(facesContext, component, UIInput.class);
        HtmlRendererUtils.decodeUIInput(facesContext, component);
        if (component instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(component)) {
            HtmlRendererUtils.decodeClientBehaviors(facesContext, component);
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIOutput.class);
        return RendererUtils.getConvertedUIOutputValue(facesContext, (UIOutput)uiComponent, submittedValue);
    }
}

