/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tomahawk.application;

import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared_tomahawk.application.FacesServletMapping;
import org.apache.myfaces.tomahawk.application.ResourceHandlerSupport;

public class DefaultResourceHandlerSupport
implements ResourceHandlerSupport {
    private static final String CACHED_SERVLET_MAPPING = DefaultResourceHandlerSupport.class.getName() + ".CACHED_SERVLET_MAPPING";

    public String calculateResourceBasePath(FacesContext facesContext) {
        FacesServletMapping mapping = this.getFacesServletMapping(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (mapping != null) {
            String resourceBasePath = null;
            if (mapping.isExtensionMapping()) {
                resourceBasePath = externalContext.getRequestServletPath();
                int stripPoint = resourceBasePath.lastIndexOf(46);
                if (stripPoint > 0) {
                    resourceBasePath = resourceBasePath.substring(0, stripPoint);
                }
            } else {
                resourceBasePath = externalContext.getRequestPathInfo();
            }
            return resourceBasePath;
        }
        return externalContext.getRequestPathInfo();
    }

    public boolean isExtensionMapping() {
        FacesServletMapping mapping = this.getFacesServletMapping(FacesContext.getCurrentInstance());
        return mapping != null && mapping.isExtensionMapping();
    }

    public String getMapping() {
        FacesServletMapping mapping = this.getFacesServletMapping(FacesContext.getCurrentInstance());
        if (mapping != null) {
            if (mapping.isExtensionMapping()) {
                return mapping.getExtension();
            }
            return mapping.getPrefix();
        }
        return "";
    }

    protected FacesServletMapping getFacesServletMapping(FacesContext context) {
        Map attributes = context.getAttributes();
        FacesServletMapping mapping = (FacesServletMapping)attributes.get(CACHED_SERVLET_MAPPING);
        if (mapping == null) {
            ExternalContext externalContext = context.getExternalContext();
            mapping = DefaultResourceHandlerSupport.calculateFacesServletMapping(externalContext.getRequestServletPath(), externalContext.getRequestPathInfo());
            attributes.put(CACHED_SERVLET_MAPPING, mapping);
        }
        return mapping;
    }

    protected static FacesServletMapping calculateFacesServletMapping(String servletPath, String pathInfo) {
        if (pathInfo != null) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        int slashPos = servletPath.lastIndexOf(47);
        int extensionPos = servletPath.lastIndexOf(46);
        if (extensionPos > -1 && extensionPos > slashPos) {
            String extension = servletPath.substring(extensionPos);
            return FacesServletMapping.createExtensionMapping(extension);
        }
        return FacesServletMapping.createPrefixMapping(servletPath);
    }
}

