/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.cast;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.attribute.expression.language.evaluation.DateEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.DateQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageException;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageParsingException;
import org.apache.nifi.expression.AttributeExpression;

public class DateCastEvaluator
extends DateEvaluator {
    public static final String DATE_TO_STRING_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    public static final Pattern DATE_TO_STRING_PATTERN = Pattern.compile("(?:[a-zA-Z]{3} ){2}\\d{2} \\d{2}\\:\\d{2}\\:\\d{2} (?:.*?) \\d{4}");
    public static final String ALTERNATE_FORMAT_WITHOUT_MILLIS = "yyyy/MM/dd HH:mm:ss";
    public static final String ALTERNATE_FORMAT_WITH_MILLIS = "yyyy/MM/dd HH:mm:ss.SSS";
    public static final Pattern ALTERNATE_PATTERN = Pattern.compile("\\d{4}/\\d{2}/\\d{2} \\d{2}\\:\\d{2}\\:\\d{2}(\\.\\d{3})?");
    public static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");
    private final Evaluator<?> subjectEvaluator;

    public DateCastEvaluator(Evaluator<?> subjectEvaluator) {
        if (subjectEvaluator.getResultType() == AttributeExpression.ResultType.BOOLEAN) {
            throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + subjectEvaluator.getResultType() + " to " + AttributeExpression.ResultType.DATE);
        }
        this.subjectEvaluator = subjectEvaluator;
    }

    @Override
    public QueryResult<Date> evaluate(Map<String, String> attributes) {
        QueryResult<?> result = this.subjectEvaluator.evaluate(attributes);
        if (result.getValue() == null) {
            return new DateQueryResult(null);
        }
        switch (result.getResultType()) {
            case DATE: {
                return (DateQueryResult)result;
            }
            case STRING: {
                String value = ((StringQueryResult)result).getValue().trim();
                if (DATE_TO_STRING_PATTERN.matcher(value).matches()) {
                    SimpleDateFormat sdf = new SimpleDateFormat(DATE_TO_STRING_FORMAT, Locale.US);
                    try {
                        Date date = sdf.parse(value);
                        return new DateQueryResult(date);
                    }
                    catch (ParseException pe) {
                        String details = "Format: 'EEE MMM dd HH:mm:ss zzz yyyy' Value: '" + value + "'";
                        throw new AttributeExpressionLanguageException("Could not parse date using " + details, pe);
                    }
                }
                if (NUMBER_PATTERN.matcher(value).matches()) {
                    return new DateQueryResult(new Date(Long.valueOf(value)));
                }
                Matcher altMatcher = ALTERNATE_PATTERN.matcher(value);
                if (altMatcher.matches()) {
                    String millisValue = altMatcher.group(1);
                    String format = millisValue == null ? ALTERNATE_FORMAT_WITHOUT_MILLIS : ALTERNATE_FORMAT_WITH_MILLIS;
                    SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.US);
                    try {
                        Date date = sdf.parse(value);
                        return new DateQueryResult(date);
                    }
                    catch (ParseException pe) {
                        throw new AttributeExpressionLanguageException("Could not parse input as date", pe);
                    }
                }
                throw new AttributeExpressionLanguageException("Could not implicitly convert input to DATE: " + value);
            }
            case WHOLE_NUMBER: {
                return new DateQueryResult(new Date((Long)result.getValue()));
            }
            case DECIMAL: {
                Double resultDouble = (Double)result.getValue();
                return new DateQueryResult(new Date(resultDouble.longValue()));
            }
            case NUMBER: {
                Number numberValue = ((NumberQueryResult)result).getValue();
                return new DateQueryResult(new Date(numberValue.longValue()));
            }
        }
        return new DateQueryResult(null);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEvaluator;
    }
}

