/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.provenance.IdentifierLookup;
import org.apache.nifi.provenance.ProvenanceAuthorizableFactory;
import org.apache.nifi.provenance.ProvenanceEventBuilder;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.lineage.ComputeLineageSubmission;
import org.apache.nifi.provenance.search.Query;
import org.apache.nifi.provenance.search.QuerySubmission;
import org.apache.nifi.provenance.search.SearchableField;

public class MockProvenanceRepository
implements ProvenanceRepository {
    private final List<ProvenanceEventRecord> records = new ArrayList<ProvenanceEventRecord>();
    private final AtomicLong idGenerator = new AtomicLong(0L);

    public void registerEvents(Iterable<ProvenanceEventRecord> events) {
        for (ProvenanceEventRecord event : events) {
            this.registerEvent(event);
        }
    }

    public void registerEvent(ProvenanceEventRecord event) {
        StandardProvenanceEventRecord newRecord = event instanceof StandardProvenanceEventRecord ? (StandardProvenanceEventRecord)event : new StandardProvenanceEventRecord.Builder().fromEvent(event).build();
        newRecord.setEventId(this.idGenerator.getAndIncrement());
        this.records.add((ProvenanceEventRecord)newRecord);
    }

    public void initialize(EventReporter eventReporter, Authorizer authorizer, ProvenanceAuthorizableFactory resourceFactory, IdentifierLookup idLookup) throws IOException {
    }

    public List<ProvenanceEventRecord> getEvents(long firstRecordId, int maxRecords) throws IOException {
        if (firstRecordId > (long)this.records.size()) {
            return Collections.emptyList();
        }
        return this.records.subList((int)firstRecordId, Math.min(this.records.size(), (int)(firstRecordId + (long)maxRecords)));
    }

    public List<ProvenanceEventRecord> getEvents(long firstRecordId, int maxRecords, NiFiUser user) throws IOException {
        return this.getEvents(firstRecordId, maxRecords);
    }

    public Long getMaxEventId() {
        return this.records.size() - 1;
    }

    public ProvenanceEventRecord getEvent(long id) throws IOException {
        return null;
    }

    public QuerySubmission submitQuery(Query query, NiFiUser user) {
        throw new UnsupportedOperationException("MockProvenanceRepository does not support querying");
    }

    public QuerySubmission retrieveQuerySubmission(String queryIdentifier, NiFiUser user) {
        throw new UnsupportedOperationException("MockProvenanceRepository does not support querying");
    }

    public ComputeLineageSubmission submitLineageComputation(String flowFileUuid, NiFiUser user) {
        throw new UnsupportedOperationException("MockProvenanceRepository does not support Lineage Computation");
    }

    public ComputeLineageSubmission submitLineageComputation(long eventId, NiFiUser user) {
        throw new UnsupportedOperationException("MockProvenanceRepository does not support Lineage Computation");
    }

    public ComputeLineageSubmission retrieveLineageSubmission(String lineageIdentifier, NiFiUser user) {
        throw new UnsupportedOperationException("MockProvenanceRepository does not support Lineage Computation");
    }

    public ProvenanceEventRecord getEvent(long id, NiFiUser user) throws IOException {
        if (id > (long)this.records.size()) {
            return null;
        }
        return this.records.get((int)id);
    }

    public ComputeLineageSubmission submitExpandParents(long eventId, NiFiUser user) {
        throw new UnsupportedOperationException("MockProvenanceRepository does not support Lineage Computation");
    }

    public ComputeLineageSubmission submitExpandChildren(long eventId, NiFiUser user) {
        throw new UnsupportedOperationException("MockProvenanceRepository does not support Lineage Computation");
    }

    public void close() throws IOException {
    }

    public List<SearchableField> getSearchableFields() {
        return Collections.emptyList();
    }

    public List<SearchableField> getSearchableAttributes() {
        return Collections.emptyList();
    }

    public ProvenanceEventBuilder eventBuilder() {
        return new StandardProvenanceEventRecord.Builder();
    }

    public ProvenanceEventRepository getProvenanceEventRepository() {
        return this;
    }

    public long getContainerCapacity(String containerName) throws IOException {
        return 0L;
    }

    public String getContainerFileStoreName(String containerName) {
        return null;
    }

    public Set<String> getContainerNames() {
        return new HashSet<String>();
    }

    public long getContainerUsableSpace(String containerName) throws IOException {
        return 0L;
    }
}

