/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.state;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.state.MockStateMap;
import org.junit.Assert;

public class MockStateManager
implements StateManager {
    private final AtomicInteger versionIndex = new AtomicInteger(0);
    private StateMap localStateMap = new MockStateMap(null, -1L);
    private StateMap clusterStateMap = new MockStateMap(null, -1L);
    private volatile boolean failToGetLocalState = false;
    private volatile boolean failToSetLocalState = false;
    private volatile boolean failToGetClusterState = false;
    private volatile boolean failToSetClusterState = false;
    private final boolean usesLocalState;
    private final boolean usesClusterState;

    public MockStateManager(Object component) {
        Stateful stateful = component.getClass().getAnnotation(Stateful.class);
        if (stateful == null) {
            this.usesLocalState = false;
            this.usesClusterState = false;
        } else {
            Scope[] scopes = stateful.scopes();
            boolean local = false;
            boolean cluster = false;
            for (Scope scope : scopes) {
                if (scope == Scope.LOCAL) {
                    local = true;
                    continue;
                }
                if (scope != Scope.CLUSTER) continue;
                cluster = true;
            }
            this.usesLocalState = local;
            this.usesClusterState = cluster;
        }
    }

    public synchronized void setState(Map<String, String> state, Scope scope) throws IOException {
        this.verifyAnnotation(scope);
        this.verifyCanSet(scope);
        MockStateMap stateMap = new MockStateMap(state, this.versionIndex.incrementAndGet());
        if (scope == Scope.CLUSTER) {
            this.clusterStateMap = stateMap;
        } else {
            this.localStateMap = stateMap;
        }
    }

    public synchronized StateMap getState(Scope scope) throws IOException {
        this.verifyAnnotation(scope);
        this.verifyCanGet(scope);
        return this.retrieveState(scope);
    }

    private synchronized StateMap retrieveState(Scope scope) {
        this.verifyAnnotation(scope);
        if (scope == Scope.CLUSTER) {
            return this.clusterStateMap;
        }
        return this.localStateMap;
    }

    public synchronized boolean replace(StateMap oldValue, Map<String, String> newValue, Scope scope) throws IOException {
        this.verifyAnnotation(scope);
        if (scope == Scope.CLUSTER) {
            if (oldValue == this.clusterStateMap) {
                this.verifyCanSet(scope);
                this.clusterStateMap = new MockStateMap(newValue, this.versionIndex.incrementAndGet());
                return true;
            }
            return false;
        }
        if (oldValue == this.localStateMap) {
            this.verifyCanSet(scope);
            this.localStateMap = new MockStateMap(newValue, this.versionIndex.incrementAndGet());
            return true;
        }
        return false;
    }

    public synchronized void clear(Scope scope) throws IOException {
        this.verifyAnnotation(scope);
        this.setState(Collections.emptyMap(), scope);
    }

    private void verifyCanSet(Scope scope) throws IOException {
        boolean failToSet;
        boolean bl = failToSet = scope == Scope.LOCAL ? this.failToSetLocalState : this.failToSetClusterState;
        if (failToSet) {
            throw new IOException("Unit Test configured to throw IOException if " + scope + " State is set");
        }
    }

    private void verifyCanGet(Scope scope) throws IOException {
        boolean failToGet;
        boolean bl = failToGet = scope == Scope.LOCAL ? this.failToGetLocalState : this.failToGetClusterState;
        if (failToGet) {
            throw new IOException("Unit Test configured to throw IOException if " + scope + " State is retrieved");
        }
    }

    private void verifyAnnotation(Scope scope) {
        if (scope == Scope.LOCAL && !this.usesLocalState || scope == Scope.CLUSTER && !this.usesClusterState) {
            Assert.fail((String)("Component is attempting to set or retrieve state with a scope of " + scope + " but does not declare that it will use " + scope + " state. A @Stateful annotation should be added to the component with a scope of " + scope));
        }
    }

    private String getValue(String key, Scope scope) {
        StateMap stateMap = scope == Scope.CLUSTER ? this.clusterStateMap : this.localStateMap;
        return stateMap.get(key);
    }

    public void assertStateEquals(String key, String value, Scope scope) {
        Assert.assertEquals((Object)value, (Object)this.getValue(key, scope));
    }

    public void assertStateEquals(Map<String, String> stateValues, Scope scope) {
        StateMap stateMap = this.retrieveState(scope);
        Assert.assertEquals(stateValues, (Object)stateMap.toMap());
    }

    public void assertStateNotEquals(Map<String, String> stateValues, Scope scope) {
        StateMap stateMap = this.retrieveState(scope);
        Assert.assertNotSame(stateValues, (Object)stateMap.toMap());
    }

    public void assertStateNotEquals(String key, String value, Scope scope) {
        Assert.assertNotEquals((Object)value, (Object)this.getValue(key, scope));
    }

    public void assertStateSet(String key, Scope scope) {
        Assert.assertNotNull((String)("Expected state to be set for key " + key + " and scope " + scope + ", but it was not set"), (Object)this.getValue(key, scope));
    }

    public void assertStateNotSet(String key, Scope scope) {
        Assert.assertNull((String)("Expected state not to be set for key " + key + " and scope " + scope + ", but it was set"), (Object)this.getValue(key, scope));
    }

    public void assertStateSet(Scope scope) {
        StateMap stateMap = scope == Scope.CLUSTER ? this.clusterStateMap : this.localStateMap;
        Assert.assertNotSame((String)("Expected state to be set for Scope " + scope + ", but it was not set"), (Object)-1L, (Object)stateMap.getVersion());
    }

    public void assertStateNotSet(Scope scope) {
        StateMap stateMap = scope == Scope.CLUSTER ? this.clusterStateMap : this.localStateMap;
        Assert.assertEquals((String)("Expected state not to be set for Scope " + scope + ", but it was set"), (long)-1L, (long)stateMap.getVersion());
    }

    public void setFailOnStateSet(Scope scope, boolean fail) {
        if (scope == Scope.LOCAL) {
            this.failToSetLocalState = fail;
        } else {
            this.failToSetClusterState = fail;
        }
    }

    public void setFailOnStateGet(Scope scope, boolean fail) {
        if (scope == Scope.LOCAL) {
            this.failToGetLocalState = fail;
        } else {
            this.failToGetClusterState = fail;
        }
    }
}

