/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.action.Action;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.reporting.EventAccess;

public class MockEventAccess
implements EventAccess {
    private ProcessGroupStatus processGroupStatus;
    private final List<ProvenanceEventRecord> provenanceRecords = new ArrayList<ProvenanceEventRecord>();
    private final List<Action> flowChanges = new ArrayList<Action>();
    private final Map<String, ProcessGroupStatus> processGroupStatusMap = new HashMap<String, ProcessGroupStatus>();

    public void setProcessGroupStatus(ProcessGroupStatus status) {
        this.processGroupStatus = status;
    }

    public void setProcessGroupStatus(String groupId, ProcessGroupStatus status) {
        this.processGroupStatusMap.put(groupId, status);
    }

    public ProcessGroupStatus getControllerStatus() {
        return this.processGroupStatus;
    }

    public ProcessGroupStatus getGroupStatus(String groupId) {
        return this.processGroupStatusMap.get(groupId);
    }

    public List<ProvenanceEventRecord> getProvenanceEvents(long firstEventId, int maxRecords) throws IOException {
        if (firstEventId < 0L || maxRecords < 1) {
            throw new IllegalArgumentException();
        }
        ArrayList<ProvenanceEventRecord> records = new ArrayList<ProvenanceEventRecord>();
        for (ProvenanceEventRecord record : this.provenanceRecords) {
            if (record.getEventId() < firstEventId) continue;
            records.add(record);
            if (records.size() < maxRecords) continue;
            return records;
        }
        return records;
    }

    public void addProvenanceEvent(ProvenanceEventRecord record) {
        this.provenanceRecords.add(record);
    }

    public ProvenanceEventRepository getProvenanceRepository() {
        return null;
    }

    public List<Action> getFlowChanges(int firstActionId, int maxActions) {
        if (firstActionId < 0 || maxActions < 1) {
            throw new IllegalArgumentException();
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Action action : this.flowChanges) {
            if (action.getId() < firstActionId) continue;
            actions.add(action);
            if (actions.size() < maxActions) continue;
            return actions;
        }
        return actions;
    }

    public void addFlowChange(Action action) {
        this.flowChanges.add(action);
    }
}

