/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.util.MockProcessSession;
import org.apache.nifi.util.SharedSessionState;

public class MockSessionFactory
implements ProcessSessionFactory {
    private final Processor processor;
    private final SharedSessionState sharedState;
    private final Set<MockProcessSession> createdSessions = new CopyOnWriteArraySet<MockProcessSession>();
    private final boolean enforceReadStreamsClosed;

    MockSessionFactory(SharedSessionState sharedState, Processor processor, boolean enforceReadStreamsClosed) {
        this.sharedState = sharedState;
        this.processor = processor;
        this.enforceReadStreamsClosed = enforceReadStreamsClosed;
    }

    public ProcessSession createSession() {
        MockProcessSession session = new MockProcessSession(this.sharedState, this.processor, this.enforceReadStreamsClosed);
        this.createdSessions.add(session);
        return session;
    }

    Set<MockProcessSession> getCreatedSessions() {
        return Collections.unmodifiableSet(this.createdSessions);
    }
}

