/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.lifecycle.OnAdded;
import org.apache.nifi.annotation.lifecycle.OnConfigurationRestored;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.registry.VariableDescriptor;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.state.MockStateManager;
import org.apache.nifi.util.ControllerServiceConfiguration;
import org.apache.nifi.util.FlowFileValidator;
import org.apache.nifi.util.MockComponentLog;
import org.apache.nifi.util.MockConfigurationContext;
import org.apache.nifi.util.MockControllerServiceInitializationContext;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.MockFlowFileQueue;
import org.apache.nifi.util.MockProcessContext;
import org.apache.nifi.util.MockProcessSession;
import org.apache.nifi.util.MockProcessorInitializationContext;
import org.apache.nifi.util.MockSessionFactory;
import org.apache.nifi.util.MockValidationContext;
import org.apache.nifi.util.MockVariableRegistry;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.util.SharedSessionState;
import org.apache.nifi.util.TestRunner;
import org.junit.Assert;

public class StandardProcessorTestRunner
implements TestRunner {
    private final Processor processor;
    private final MockProcessContext context;
    private final MockFlowFileQueue flowFileQueue;
    private final SharedSessionState sharedState;
    private final AtomicLong idGenerator;
    private final boolean triggerSerially;
    private final MockStateManager processorStateManager;
    private final Map<String, MockStateManager> controllerServiceStateManagers = new HashMap<String, MockStateManager>();
    private final MockVariableRegistry variableRegistry;
    private int numThreads = 1;
    private MockSessionFactory sessionFactory;
    private long runSchedule = 0L;
    private final AtomicInteger invocations = new AtomicInteger(0);
    private final Map<String, MockComponentLog> controllerServiceLoggers = new HashMap<String, MockComponentLog>();
    private final MockComponentLog logger;
    private boolean enforceReadStreamsClosed = true;

    StandardProcessorTestRunner(Processor processor) {
        this.processor = processor;
        this.idGenerator = new AtomicLong(0L);
        this.sharedState = new SharedSessionState(processor, this.idGenerator);
        this.flowFileQueue = this.sharedState.getFlowFileQueue();
        this.sessionFactory = new MockSessionFactory(this.sharedState, processor, this.enforceReadStreamsClosed);
        this.processorStateManager = new MockStateManager(processor);
        this.variableRegistry = new MockVariableRegistry();
        this.context = new MockProcessContext((ConfigurableComponent)processor, this.processorStateManager, this.variableRegistry);
        MockProcessorInitializationContext mockInitContext = new MockProcessorInitializationContext(processor, this.context);
        processor.initialize((ProcessorInitializationContext)mockInitContext);
        this.logger = mockInitContext.getLogger();
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, processor, new Object[0]);
        }
        catch (Exception e) {
            Assert.fail((String)("Could not invoke methods annotated with @OnAdded annotation due to: " + e));
        }
        this.triggerSerially = null != processor.getClass().getAnnotation(TriggerSerially.class);
        ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, processor, new Object[0]);
    }

    @Override
    public void enforceReadStreamsClosed(boolean enforce) {
        this.enforceReadStreamsClosed = enforce;
        this.sessionFactory = new MockSessionFactory(this.sharedState, this.processor, this.enforceReadStreamsClosed);
    }

    @Override
    public void setValidateExpressionUsage(boolean validate) {
        this.context.setValidateExpressionUsage(validate);
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    public MockProcessContext getProcessContext() {
        return this.context;
    }

    @Override
    public void run() {
        this.run(1);
    }

    @Override
    public void run(int iterations) {
        this.run(iterations, true);
    }

    @Override
    public void run(int iterations, boolean stopOnFinish) {
        this.run(iterations, stopOnFinish, true);
    }

    @Override
    public void run(int iterations, boolean stopOnFinish, boolean initialize) {
        this.run(iterations, stopOnFinish, initialize, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(int iterations, boolean stopOnFinish, boolean initialize, long runWait) {
        if (iterations < 1) {
            throw new IllegalArgumentException();
        }
        this.context.assertValid();
        this.context.enableExpressionValidation();
        try {
            if (initialize) {
                try {
                    ReflectionUtils.invokeMethodsWithAnnotation(OnScheduled.class, this.processor, this.context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)("Could not invoke methods annotated with @OnScheduled annotation due to: " + e));
                }
            }
            ScheduledExecutorService executorService = Executors.newScheduledThreadPool(this.numThreads);
            Future[] futures = new Future[iterations];
            for (int i = 0; i < iterations; ++i) {
                ScheduledFuture<Throwable> future;
                futures[i] = future = executorService.schedule(new RunProcessor(), (long)i * this.runSchedule, TimeUnit.MILLISECONDS);
            }
            executorService.shutdown();
            try {
                executorService.awaitTermination(runWait, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            int finishedCount = 0;
            boolean unscheduledRun = false;
            for (Future future : futures) {
                try {
                    Throwable thrown = (Throwable)future.get();
                    if (thrown != null) {
                        throw new AssertionError((Object)thrown);
                    }
                    if (++finishedCount != 1) continue;
                    unscheduledRun = true;
                    try {
                        ReflectionUtils.invokeMethodsWithAnnotation(OnUnscheduled.class, this.processor, this.context);
                    }
                    catch (Exception e) {
                        Assert.fail((String)("Could not invoke methods annotated with @OnUnscheduled annotation due to: " + e));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!unscheduledRun) {
                try {
                    ReflectionUtils.invokeMethodsWithAnnotation(OnUnscheduled.class, this.processor, this.context);
                }
                catch (Exception e) {
                    Assert.fail((String)("Could not invoke methods annotated with @OnUnscheduled annotation due to: " + e));
                }
            }
            if (stopOnFinish) {
                try {
                    ReflectionUtils.invokeMethodsWithAnnotation(OnStopped.class, this.processor, this.context);
                }
                catch (Exception e) {
                    Assert.fail((String)("Could not invoke methods annotated with @OnStopped annotation due to: " + e));
                }
            }
        }
        finally {
            this.context.disableExpressionValidation();
        }
    }

    @Override
    public void shutdown() {
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(OnShutdown.class, this.processor, new Object[0]);
        }
        catch (Exception e) {
            Assert.fail((String)("Could not invoke methods annotated with @OnShutdown annotation due to: " + e));
        }
    }

    @Override
    public ProcessSessionFactory getProcessSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public void assertAllFlowFilesTransferred(String relationship) {
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            session.assertAllFlowFilesTransferred(relationship);
        }
    }

    @Override
    public void assertAllFlowFilesTransferred(Relationship relationship) {
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            session.assertAllFlowFilesTransferred(relationship);
        }
    }

    @Override
    public void assertAllFlowFilesTransferred(String relationship, int count) {
        this.assertAllFlowFilesTransferred(relationship);
        this.assertTransferCount(relationship, count);
    }

    @Override
    public void assertAllFlowFilesContainAttribute(final String attributeName) {
        this.assertAllFlowFiles(new FlowFileValidator(){

            @Override
            public void assertFlowFile(FlowFile f) {
                Assert.assertTrue((f.getAttribute(attributeName) != null ? 1 : 0) != 0);
            }
        });
    }

    @Override
    public void assertAllFlowFilesContainAttribute(Relationship relationship, final String attributeName) {
        this.assertAllFlowFiles(relationship, new FlowFileValidator(){

            @Override
            public void assertFlowFile(FlowFile f) {
                Assert.assertTrue((f.getAttribute(attributeName) != null ? 1 : 0) != 0);
            }
        });
    }

    @Override
    public void assertAllFlowFiles(FlowFileValidator validator) {
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            session.assertAllFlowFiles(validator);
        }
    }

    @Override
    public void assertAllFlowFiles(Relationship relationship, FlowFileValidator validator) {
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            session.assertAllFlowFiles(relationship, validator);
        }
    }

    @Override
    public void assertAllFlowFilesTransferred(Relationship relationship, int count) {
        this.assertAllFlowFilesTransferred(relationship);
        this.assertTransferCount(relationship, count);
    }

    @Override
    public void assertTransferCount(Relationship relationship, int count) {
        Assert.assertEquals((long)count, (long)this.getFlowFilesForRelationship(relationship).size());
    }

    @Override
    public void assertTransferCount(String relationship, int count) {
        Assert.assertEquals((long)count, (long)this.getFlowFilesForRelationship(relationship).size());
    }

    @Override
    public void assertPenalizeCount(int count) {
        Assert.assertEquals((long)count, (long)this.getPenalizedFlowFiles().size());
    }

    @Override
    public void assertValid() {
        this.context.assertValid();
    }

    @Override
    public void assertNotValid() {
        Assert.assertFalse((String)"Processor appears to be valid but expected it to be invalid", (boolean)this.context.isValid());
    }

    @Override
    public boolean isQueueEmpty() {
        return this.flowFileQueue.isEmpty();
    }

    @Override
    public void assertQueueEmpty() {
        Assert.assertTrue((boolean)this.flowFileQueue.isEmpty());
    }

    @Override
    public void assertQueueNotEmpty() {
        Assert.assertFalse((boolean)this.flowFileQueue.isEmpty());
    }

    @Override
    public void clearTransferState() {
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            session.clearTransferState();
        }
    }

    @Override
    public void enqueue(FlowFile ... flowFiles) {
        for (FlowFile flowFile : flowFiles) {
            this.flowFileQueue.offer((MockFlowFile)flowFile);
        }
    }

    @Override
    public MockFlowFile enqueue(Path path) throws IOException {
        return this.enqueue(path, new HashMap<String, String>());
    }

    @Override
    public MockFlowFile enqueue(Path path, Map<String, String> attributes) throws IOException {
        HashMap<String, String> modifiedAttributes = new HashMap<String, String>(attributes);
        if (!modifiedAttributes.containsKey(CoreAttributes.FILENAME.key())) {
            modifiedAttributes.put(CoreAttributes.FILENAME.key(), path.toFile().getName());
        }
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            MockFlowFile mockFlowFile = this.enqueue(in, modifiedAttributes);
            return mockFlowFile;
        }
    }

    @Override
    public MockFlowFile enqueue(byte[] data) {
        return this.enqueue(data, new HashMap<String, String>());
    }

    @Override
    public MockFlowFile enqueue(String data) {
        return this.enqueue(data.getBytes(StandardCharsets.UTF_8), Collections.emptyMap());
    }

    @Override
    public MockFlowFile enqueue(byte[] data, Map<String, String> attributes) {
        return this.enqueue(new ByteArrayInputStream(data), attributes);
    }

    @Override
    public MockFlowFile enqueue(String data, Map<String, String> attributes) {
        return this.enqueue(data.getBytes(StandardCharsets.UTF_8), attributes);
    }

    @Override
    public MockFlowFile enqueue(InputStream data) {
        return this.enqueue(data, new HashMap<String, String>());
    }

    @Override
    public MockFlowFile enqueue(InputStream data, Map<String, String> attributes) {
        MockProcessSession session = new MockProcessSession(new SharedSessionState(this.processor, this.idGenerator), this.processor, this.enforceReadStreamsClosed);
        MockFlowFile flowFile = session.create();
        flowFile = session.importFrom(data, (FlowFile)flowFile);
        flowFile = session.putAllAttributes((FlowFile)flowFile, attributes);
        this.enqueue(new FlowFile[]{flowFile});
        return flowFile;
    }

    @Override
    public byte[] getContentAsByteArray(MockFlowFile flowFile) {
        return flowFile.getData();
    }

    @Override
    public List<MockFlowFile> getFlowFilesForRelationship(String relationship) {
        Relationship rel = new Relationship.Builder().name(relationship).build();
        return this.getFlowFilesForRelationship(rel);
    }

    @Override
    public List<MockFlowFile> getFlowFilesForRelationship(Relationship relationship) {
        ArrayList<MockFlowFile> flowFiles = new ArrayList<MockFlowFile>();
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            flowFiles.addAll(session.getFlowFilesForRelationship(relationship));
        }
        Collections.sort(flowFiles, new Comparator<MockFlowFile>(){

            @Override
            public int compare(MockFlowFile o1, MockFlowFile o2) {
                return Long.compare(o1.getCreationTime(), o2.getCreationTime());
            }
        });
        return flowFiles;
    }

    @Override
    public List<MockFlowFile> getPenalizedFlowFiles() {
        ArrayList<MockFlowFile> flowFiles = new ArrayList<MockFlowFile>();
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            flowFiles.addAll(session.getPenalizedFlowFiles());
        }
        Collections.sort(flowFiles, new Comparator<MockFlowFile>(){

            @Override
            public int compare(MockFlowFile o1, MockFlowFile o2) {
                return Long.compare(o1.getCreationTime(), o2.getCreationTime());
            }
        });
        return flowFiles;
    }

    @Override
    public QueueSize getQueueSize() {
        return this.flowFileQueue.size();
    }

    public void clearQueue() {
        while (!this.flowFileQueue.isEmpty()) {
            this.flowFileQueue.poll();
        }
    }

    @Override
    public Long getCounterValue(String name) {
        return this.sharedState.getCounterValue(name);
    }

    @Override
    public int getRemovedCount() {
        int count = 0;
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            count += session.getRemovedCount();
        }
        return count;
    }

    @Override
    public void setAnnotationData(String annotationData) {
        this.context.setAnnotationData(annotationData);
    }

    @Override
    public ValidationResult setProperty(String propertyName, String propertyValue) {
        return this.context.setProperty(propertyName, propertyValue);
    }

    @Override
    public ValidationResult setProperty(PropertyDescriptor descriptor, String value) {
        return this.context.setProperty(descriptor, value);
    }

    @Override
    public ValidationResult setProperty(PropertyDescriptor descriptor, AllowableValue value) {
        return this.context.setProperty(descriptor, value.getValue());
    }

    @Override
    public void setThreadCount(int threadCount) {
        if (threadCount > 1 && this.triggerSerially) {
            Assert.fail((String)"Cannot set thread-count higher than 1 because the processor is triggered serially");
        }
        this.numThreads = threadCount;
        this.context.setMaxConcurrentTasks(threadCount);
    }

    @Override
    public int getThreadCount() {
        return this.numThreads;
    }

    @Override
    public void setRelationshipAvailable(Relationship relationship) {
        HashSet<Relationship> unavailable = new HashSet<Relationship>(this.context.getUnavailableRelationships());
        unavailable.remove(relationship);
        this.context.setUnavailableRelationships(unavailable);
    }

    @Override
    public void setRelationshipAvailable(String relationshipName) {
        this.setRelationshipAvailable(new Relationship.Builder().name(relationshipName).build());
    }

    @Override
    public void setRelationshipUnavailable(Relationship relationship) {
        HashSet<Relationship> unavailable = new HashSet<Relationship>(this.context.getUnavailableRelationships());
        unavailable.add(relationship);
        this.context.setUnavailableRelationships(unavailable);
    }

    @Override
    public void setRelationshipUnavailable(String relationshipName) {
        this.setRelationshipUnavailable(new Relationship.Builder().name(relationshipName).build());
    }

    @Override
    public void setIncomingConnection(boolean hasIncomingConnection) {
        this.context.setIncomingConnection(hasIncomingConnection);
    }

    @Override
    public void setNonLoopConnection(boolean hasNonLoopConnection) {
        this.context.setNonLoopConnection(hasNonLoopConnection);
    }

    @Override
    public void addConnection(Relationship relationship) {
        this.context.addConnection(relationship);
    }

    @Override
    public void addConnection(String relationshipName) {
        this.addConnection(new Relationship.Builder().name(relationshipName).build());
    }

    @Override
    public void removeConnection(Relationship relationship) {
        this.context.removeConnection(relationship);
    }

    @Override
    public void removeConnection(String relationshipName) {
        this.removeConnection(new Relationship.Builder().name(relationshipName).build());
    }

    @Override
    public void addControllerService(String identifier, ControllerService service) throws InitializationException {
        this.addControllerService(identifier, service, new HashMap<String, String>());
    }

    @Override
    public void addControllerService(String identifier, ControllerService service, Map<String, String> properties) throws InitializationException {
        MockComponentLog logger = new MockComponentLog(identifier, service);
        this.controllerServiceLoggers.put(identifier, logger);
        MockStateManager serviceStateManager = new MockStateManager(service);
        MockControllerServiceInitializationContext initContext = new MockControllerServiceInitializationContext(Objects.requireNonNull(service), Objects.requireNonNull(identifier), logger, serviceStateManager);
        this.controllerServiceStateManagers.put(identifier, serviceStateManager);
        initContext.addControllerServices(this.context);
        service.initialize((ControllerServiceInitializationContext)initContext);
        HashMap<PropertyDescriptor, String> resolvedProps = new HashMap<PropertyDescriptor, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            resolvedProps.put(service.getPropertyDescriptor(entry.getKey()), entry.getValue());
        }
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, service, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new InitializationException((Throwable)e);
        }
        this.context.addControllerService(identifier, service, resolvedProps, null);
    }

    @Override
    public void assertNotValid(ControllerService service) {
        StateManager serviceStateManager = this.controllerServiceStateManagers.get(service.getIdentifier());
        if (serviceStateManager == null) {
            throw new IllegalStateException("Controller Service has not been added to this TestRunner via the #addControllerService method");
        }
        ValidationContext validationContext = new MockValidationContext(this.context, serviceStateManager, this.variableRegistry).getControllerServiceValidationContext(service);
        Collection results = this.context.getControllerService(service.getIdentifier()).validate(validationContext);
        for (ValidationResult result : results) {
            if (result.isValid()) continue;
            return;
        }
        Assert.fail((String)("Expected Controller Service " + service + " to be invalid but it is valid"));
    }

    @Override
    public void assertValid(ControllerService service) {
        StateManager serviceStateManager = this.controllerServiceStateManagers.get(service.getIdentifier());
        if (serviceStateManager == null) {
            throw new IllegalStateException("Controller Service has not been added to this TestRunner via the #addControllerService method");
        }
        ValidationContext validationContext = new MockValidationContext(this.context, serviceStateManager, this.variableRegistry).getControllerServiceValidationContext(service);
        Collection results = this.context.getControllerService(service.getIdentifier()).validate(validationContext);
        for (ValidationResult result : results) {
            if (result.isValid()) continue;
            Assert.fail((String)("Expected Controller Service to be valid but it is invalid due to: " + result.toString()));
        }
    }

    @Override
    public void disableControllerService(ControllerService service) {
        ControllerServiceConfiguration configuration = this.context.getConfiguration(service.getIdentifier());
        if (configuration == null) {
            throw new IllegalArgumentException("Controller Service " + service + " is not known");
        }
        if (!configuration.isEnabled()) {
            throw new IllegalStateException("Controller service " + service + " cannot be disabled because it is not enabled");
        }
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(OnDisabled.class, service, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to disable Controller Service " + service + " due to " + e));
        }
        configuration.setEnabled(false);
    }

    @Override
    public void enableControllerService(ControllerService service) {
        ControllerServiceConfiguration configuration = this.context.getConfiguration(service.getIdentifier());
        if (configuration == null) {
            throw new IllegalArgumentException("Controller Service " + service + " is not known");
        }
        if (configuration.isEnabled()) {
            throw new IllegalStateException("Cannot enable Controller Service " + service + " because it is not disabled");
        }
        ValidationContext validationContext = new MockValidationContext(this.context).getControllerServiceValidationContext(service);
        Collection results = this.context.getControllerService(service.getIdentifier()).validate(validationContext);
        for (ValidationResult result : results) {
            if (result.isValid()) continue;
            throw new IllegalStateException("Cannot enable Controller Service " + service + " because it is in an invalid state: " + result.toString());
        }
        try {
            MockConfigurationContext configContext = new MockConfigurationContext(service, configuration.getProperties(), this.context, this.variableRegistry);
            ReflectionUtils.invokeMethodsWithAnnotation(OnEnabled.class, service, configContext);
        }
        catch (InvocationTargetException ite) {
            ite.getCause().printStackTrace();
            Assert.fail((String)("Failed to enable Controller Service " + service + " due to " + ite.getCause()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to enable Controller Service " + service + " due to " + e));
        }
        configuration.setEnabled(true);
    }

    @Override
    public boolean isControllerServiceEnabled(ControllerService service) {
        ControllerServiceConfiguration configuration = this.context.getConfiguration(service.getIdentifier());
        if (configuration == null) {
            throw new IllegalArgumentException("Controller Service " + service + " is not known");
        }
        return configuration.isEnabled();
    }

    @Override
    public void removeControllerService(ControllerService service) {
        if (this.context.getControllerServiceLookup().isControllerServiceEnabled(service)) {
            this.disableControllerService(service);
        }
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(OnRemoved.class, service, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to remove Controller Service " + service + " due to " + e));
        }
        this.context.removeControllerService(service);
    }

    @Override
    public void setAnnotationData(ControllerService service, String annotationData) {
        ControllerServiceConfiguration configuration = this.getConfigToUpdate(service);
        configuration.setAnnotationData(annotationData);
    }

    private ControllerServiceConfiguration getConfigToUpdate(ControllerService service) {
        ControllerServiceConfiguration configuration = this.context.getConfiguration(service.getIdentifier());
        if (configuration == null) {
            throw new IllegalArgumentException("Controller Service " + service + " is not known");
        }
        if (configuration.isEnabled()) {
            throw new IllegalStateException("Controller service " + service + " cannot be modified because it is not disabled");
        }
        return configuration;
    }

    @Override
    public ValidationResult setProperty(ControllerService service, PropertyDescriptor property, AllowableValue value) {
        return this.setProperty(service, property, value.getValue());
    }

    @Override
    public ValidationResult setProperty(ControllerService service, PropertyDescriptor property, String value) {
        MockStateManager serviceStateManager = this.controllerServiceStateManagers.get(service.getIdentifier());
        if (serviceStateManager == null) {
            throw new IllegalStateException("Controller service " + service + " has not been added to this TestRunner via the #addControllerService method");
        }
        ControllerServiceConfiguration configuration = this.getConfigToUpdate(service);
        Map<PropertyDescriptor, String> curProps = configuration.getProperties();
        HashMap<PropertyDescriptor, String> updatedProps = new HashMap<PropertyDescriptor, String>(curProps);
        ValidationContext validationContext = new MockValidationContext(this.context, serviceStateManager, this.variableRegistry).getControllerServiceValidationContext(service);
        ValidationResult validationResult = property.validate(value, validationContext);
        String oldValue = (String)updatedProps.get(property);
        updatedProps.put(property, value);
        configuration.setProperties(updatedProps);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            service.onPropertyModified(property, oldValue, value);
        }
        return validationResult;
    }

    @Override
    public ValidationResult setProperty(ControllerService service, String propertyName, String value) {
        PropertyDescriptor descriptor = service.getPropertyDescriptor(propertyName);
        if (descriptor == null) {
            return new ValidationResult.Builder().input(propertyName).explanation(propertyName + " is not a known Property for Controller Service " + service).subject("Invalid property").valid(false).build();
        }
        return this.setProperty(service, descriptor, value);
    }

    @Override
    public ControllerService getControllerService(String identifier) {
        return this.context.getControllerService(identifier);
    }

    @Override
    public <T extends ControllerService> T getControllerService(String identifier, Class<T> serviceType) {
        ControllerService service = this.context.getControllerService(identifier);
        return (T)((ControllerService)serviceType.cast(service));
    }

    @Override
    public boolean removeProperty(PropertyDescriptor descriptor) {
        return this.context.removeProperty(descriptor);
    }

    @Override
    public boolean removeProperty(String property) {
        return this.context.removeProperty(property);
    }

    @Override
    public List<ProvenanceEventRecord> getProvenanceEvents() {
        return this.sharedState.getProvenanceEvents();
    }

    @Override
    public void clearProvenanceEvents() {
        this.sharedState.clearProvenanceEvents();
    }

    @Override
    public MockStateManager getStateManager() {
        return this.processorStateManager;
    }

    @Override
    public MockStateManager getStateManager(ControllerService controllerService) {
        return this.controllerServiceStateManagers.get(controllerService.getIdentifier());
    }

    @Override
    public MockComponentLog getLogger() {
        return this.logger;
    }

    @Override
    public MockComponentLog getControllerServiceLogger(String identifier) {
        return this.controllerServiceLoggers.get(identifier);
    }

    @Override
    public void setClustered(boolean clustered) {
        this.context.setClustered(clustered);
    }

    @Override
    public void setPrimaryNode(boolean primaryNode) {
        this.context.setPrimaryNode(primaryNode);
    }

    @Override
    public String getVariableValue(String name) {
        Objects.requireNonNull(name);
        return this.variableRegistry.getVariableValue(name);
    }

    @Override
    public void setVariable(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        VariableDescriptor descriptor = new VariableDescriptor.Builder(name).build();
        this.variableRegistry.setVariable(descriptor, value);
    }

    @Override
    public String removeVariable(String name) {
        Objects.requireNonNull(name);
        return this.variableRegistry.removeVariable(new VariableDescriptor.Builder(name).build());
    }

    @Override
    public void assertAllConditionsMet(String relationshipName, Predicate<MockFlowFile> predicate) {
        this.assertAllConditionsMet(new Relationship.Builder().name(relationshipName).build(), predicate);
    }

    @Override
    public void assertAllConditionsMet(Relationship relationship, Predicate<MockFlowFile> predicate) {
        List<MockFlowFile> flowFiles;
        if (predicate == null) {
            Assert.fail((String)"predicate cannot be null");
        }
        if ((flowFiles = this.getFlowFilesForRelationship(relationship)).isEmpty()) {
            Assert.fail((String)("Relationship " + relationship.getName() + " does not contain any FlowFile"));
        }
        for (MockFlowFile flowFile : flowFiles) {
            if (predicate.test(flowFile)) continue;
            Assert.fail((String)("FlowFile " + flowFile + " does not meet all condition"));
        }
    }

    @Override
    public void setRunSchedule(long runSchedule) {
        this.runSchedule = runSchedule;
    }

    private class RunProcessor
    implements Callable<Throwable> {
        private RunProcessor() {
        }

        @Override
        public Throwable call() throws Exception {
            StandardProcessorTestRunner.this.invocations.incrementAndGet();
            try {
                StandardProcessorTestRunner.this.processor.onTrigger((ProcessContext)StandardProcessorTestRunner.this.context, (ProcessSessionFactory)StandardProcessorTestRunner.this.sessionFactory);
            }
            catch (Throwable t) {
                return t;
            }
            return null;
        }
    }
}

