/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.openidconnect.client.response;

import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.jwt.JWT;
import org.apache.oltu.oauth2.jwt.io.JWTReader;

public class OpenIdConnectResponse
extends OAuthJSONAccessTokenResponse {
    private JWT idToken;

    protected void init(String body, String contentType, int responseCode) throws OAuthProblemException {
        super.init(body, contentType, responseCode);
        this.idToken = (JWT)new JWTReader().read(this.getParam("id_token"));
    }

    public final JWT getIdToken() {
        return this.idToken;
    }

    public boolean checkId(String issuer, String audience) {
        return this.idToken.getClaimsSet().getIssuer().equals(issuer) && this.idToken.getClaimsSet().getAudience().equals(audience) && this.idToken.getClaimsSet().getExpirationTime() < System.currentTimeMillis();
    }
}

