/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi.std;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.openaz.pepapi.MapperRegistry;
import org.apache.openaz.pepapi.ObjectMapper;
import org.apache.openaz.pepapi.PepConfig;
import org.apache.openaz.pepapi.PepRequest;
import org.apache.openaz.pepapi.PepRequestAttributes;
import org.apache.openaz.pepapi.std.StdPepRequestAttributes;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.RequestAttributesReference;
import org.apache.openaz.xacml.api.RequestReference;
import org.apache.openaz.xacml.std.StdMutableRequest;
import org.apache.openaz.xacml.std.StdMutableRequestReference;
import org.apache.openaz.xacml.std.StdRequestAttributesReference;

final class MultiRequest
implements PepRequest {
    private static final String REQUEST_ATTR_ID_PREFIX = "attributes";
    private final Map<Identifier, PepRequestAttributes> pepRequestAttributesMapByCategory = new HashMap<Identifier, PepRequestAttributes>();
    private final MapperRegistry mapperRegistry;
    private final PepConfig pepConfig;
    private final Object[] sharedRequestObjects;
    private List<?> associations;
    private final AtomicInteger idCounter;
    private final StdMutableRequest wrappedRequest;
    private StdMutableRequestReference currentRequestReference;
    private RequestReference sharedRequestReference;

    static MultiRequest newInstance(PepConfig pepConfig, MapperRegistry mapperRegistry, List<?> associations, Object[] sharedRequestObjects) {
        MultiRequest m = new MultiRequest(pepConfig, mapperRegistry, associations, sharedRequestObjects);
        m.mapSharedRequestObjects();
        m.mapAssociations();
        return m;
    }

    private MultiRequest(PepConfig pepConfig, MapperRegistry mapperRegistry, List<?> associations, Object[] sharedRequestObjects) {
        this.sharedRequestObjects = sharedRequestObjects;
        this.associations = associations;
        this.mapperRegistry = mapperRegistry;
        this.pepConfig = pepConfig;
        this.idCounter = new AtomicInteger(1);
        this.wrappedRequest = new StdMutableRequest();
        this.currentRequestReference = new StdMutableRequestReference();
    }

    private void mapSharedRequestObjects() {
        if (this.sharedRequestObjects == null) {
            throw new IllegalArgumentException("One or more arguments are null");
        }
        for (Object o : this.sharedRequestObjects) {
            if (o == null) {
                throw new IllegalArgumentException("One or more arguments are null");
            }
            ObjectMapper mapper = this.mapperRegistry.getMapper(o.getClass());
            if (mapper == null) {
                throw new IllegalArgumentException("No mappers found for class: " + o.getClass().getName());
            }
            mapper.map(o, this);
        }
        this.sharedRequestReference = this.currentRequestReference;
    }

    private void mapAssociations() {
        if (this.associations == null) {
            throw new IllegalArgumentException("One or more arguments are null");
        }
        for (Object association : this.associations) {
            if (association == null) {
                throw new IllegalArgumentException("One or more arguments are null");
            }
            this.pepRequestAttributesMapByCategory.clear();
            this.currentRequestReference = new StdMutableRequestReference(this.sharedRequestReference.getAttributesReferences());
            this.wrappedRequest.add((RequestReference)this.currentRequestReference);
            ObjectMapper mapper = this.mapperRegistry.getMapper(association.getClass());
            if (mapper == null) {
                throw new IllegalArgumentException("No mappers found for class: " + association.getClass().getName());
            }
            mapper.map(association, this);
        }
    }

    @Override
    public PepRequestAttributes getPepRequestAttributes(Identifier categoryIdentifier) {
        PepRequestAttributes pepRequestAttributes = this.pepRequestAttributesMapByCategory.get(categoryIdentifier);
        if (pepRequestAttributes == null) {
            String xmlId = this.generateRequestAttributesXmlId();
            StdPepRequestAttributes p = new StdPepRequestAttributes(xmlId, categoryIdentifier);
            p.setIssuer(this.pepConfig.getIssuer());
            pepRequestAttributes = p;
            this.pepRequestAttributesMapByCategory.put(categoryIdentifier, pepRequestAttributes);
            this.wrappedRequest.add(pepRequestAttributes.getWrappedRequestAttributes());
            this.currentRequestReference.add((RequestAttributesReference)new StdRequestAttributesReference(xmlId));
        }
        return pepRequestAttributes;
    }

    private String generateRequestAttributesXmlId() {
        return REQUEST_ATTR_ID_PREFIX + this.idCounter.getAndIncrement();
    }

    @Override
    public Request getWrappedRequest() {
        return this.wrappedRequest;
    }
}

