/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi.std;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.pepapi.Attribute;
import org.apache.openaz.pepapi.MatchAllObligationAttributes;
import org.apache.openaz.pepapi.MatchAnyObligation;
import org.apache.openaz.pepapi.Matchable;
import org.apache.openaz.pepapi.Obligation;
import org.apache.openaz.pepapi.ObligationHandler;
import org.apache.openaz.pepapi.ObligationHandlerRegistry;
import org.apache.openaz.pepapi.std.ObligationCriteria;
import org.apache.openaz.pepapi.std.ObligationCriteriaBuilder;

public class StdObligationHandlerRegistry
implements ObligationHandlerRegistry {
    private static final Log logger = LogFactory.getLog(StdObligationHandlerRegistry.class);
    private final Map<Class<?>, Matchable<Obligation>> oHandlerCriteriaMap = new HashMap();

    private StdObligationHandlerRegistry(List<?> oHandlers) {
        for (Object oHandler : oHandlers) {
            Class<?> oHandlerClass = oHandler.getClass();
            Matchable<Obligation> matchable = null;
            matchable = oHandler instanceof ObligationHandler ? (ObligationHandler)oHandler : this.processAnnotation(oHandlerClass);
            if (matchable != null) {
                this.oHandlerCriteriaMap.put(oHandlerClass, matchable);
                continue;
            }
            logger.error((Object)("Obligation Handler Class: " + oHandlerClass + " is not an instance of ObligationHandler or doesn't contain a valid Annotation"));
            throw new IllegalArgumentException("Obligation Handler Class: " + oHandlerClass + " is not an instance of ObligationHandler or doesn't contain a valid Annotation");
        }
    }

    private ObligationCriteria processAnnotation(Class<?> oHandlerClass) {
        ObligationCriteria criteria = null;
        for (Annotation a : oHandlerClass.getAnnotations()) {
            if (a.annotationType().equals(MatchAnyObligation.class)) {
                String[] obligationIds = ((MatchAnyObligation)a).value();
                ObligationCriteriaBuilder criteriaBuilder = new ObligationCriteriaBuilder();
                if (obligationIds != null && obligationIds.length > 0) {
                    criteriaBuilder.matchAnyObligationId(obligationIds);
                } else {
                    criteriaBuilder.matchAnyObligation();
                }
                criteria = criteriaBuilder.build();
                continue;
            }
            if (!a.annotationType().equals(MatchAllObligationAttributes.class)) continue;
            ObligationCriteriaBuilder criteriaBuilder = new ObligationCriteriaBuilder();
            MatchAllObligationAttributes attributeObligationAnnotation = (MatchAllObligationAttributes)a;
            for (Attribute attribute : attributeObligationAnnotation.value()) {
                String attributeId = attribute.id();
                String[] anyValue = attribute.anyValue();
                if (anyValue != null && anyValue.length > 0) {
                    criteriaBuilder.matchAttributeWithAnyGivenValue(attributeId, anyValue);
                    continue;
                }
                criteriaBuilder.matchAttribute(attributeId);
            }
            criteria = criteriaBuilder.build();
        }
        return criteria;
    }

    public static ObligationHandlerRegistry newInstance(List<?> oHandlers) {
        return new StdObligationHandlerRegistry(oHandlers);
    }

    @Override
    public Map<Class<?>, Matchable<Obligation>> getRegisteredHandlerMap() {
        return this.oHandlerCriteriaMap;
    }
}

