/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi.std;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.pepapi.Matchable;
import org.apache.openaz.pepapi.Obligation;
import org.apache.openaz.pepapi.ObligationHandlerRegistry;
import org.apache.openaz.pepapi.ObligationRouter;
import org.apache.openaz.pepapi.UnhandleableObligationException;
import org.apache.openaz.pepapi.std.ThreadLocalObligationStore;

public final class StdObligationRouter
implements ObligationRouter {
    private static final Log logger = LogFactory.getLog(StdObligationRouter.class);
    private final ObligationHandlerRegistry registrationHandler;
    private final ThreadLocalObligationStore obligationStore;

    StdObligationRouter(ObligationHandlerRegistry registrationHandler, ThreadLocalObligationStore threadLocalOStore) {
        this.registrationHandler = registrationHandler;
        this.obligationStore = threadLocalOStore;
    }

    public static StdObligationRouter newInstance(ObligationHandlerRegistry registrationHandler, ThreadLocalObligationStore threadLocalOStore) {
        return new StdObligationRouter(registrationHandler, threadLocalOStore);
    }

    @Override
    public void routeObligations(Map<String, Obligation> obligationMap) {
        this.obligationStore.clear();
        if (obligationMap != null) {
            HashMap obligationMapByHandlerClass = new HashMap();
            for (Map.Entry<String, Obligation> oe : obligationMap.entrySet()) {
                boolean isObligationHandleable = false;
                String obligationId = oe.getKey();
                Obligation obligation = oe.getValue();
                for (Map.Entry<Class<?>, Matchable<Obligation>> pe : this.registrationHandler.getRegisteredHandlerMap().entrySet()) {
                    Class<?> handlerClass = pe.getKey();
                    Matchable<Obligation> matchable = pe.getValue();
                    if (!matchable.match(obligation)) continue;
                    HashSet<Obligation> handlerObligationSet = (HashSet<Obligation>)obligationMapByHandlerClass.get(handlerClass);
                    if (handlerObligationSet == null) {
                        handlerObligationSet = new HashSet<Obligation>();
                        obligationMapByHandlerClass.put(handlerClass, handlerObligationSet);
                    }
                    handlerObligationSet.add(obligation);
                    isObligationHandleable = true;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Obligation - " + obligationId + " matched by Handler - " + handlerClass));
                }
                if (isObligationHandleable) continue;
                throw new UnhandleableObligationException("No ObligationHandlers available for handling Obligation: " + oe.getKey());
            }
            this.obligationStore.setObligations(obligationMapByHandlerClass);
        }
    }
}

