/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi.std;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.pepapi.PepConfig;
import org.apache.openaz.pepapi.PepResponseBehavior;
import org.apache.openaz.xacml.api.XACML3;

public final class StdPepConfig
implements PepConfig {
    private static final Log logger = LogFactory.getLog(StdPepConfig.class);
    private static final String PEP_ISSUER = "pep.issuer";
    private static final String PEP_DEFAULT_SUBJECT_ID = "pep.subject.id";
    private static final String PEP_DEFAULT_ACTION_ID = "pep.action.id";
    private static final String PEP_DEFAULT_RESOURCE_ID = "pep.resource.id";
    private static final String PEP_INDETERMINATE_BEHAVIOR = "pep.indeterminate.behavior";
    private static final String PEP_NOTAPPLICABLE_BEHAVIOR = "pep.notapplicable.behavior";
    private static final String PEP_MAPPER_CLASSES = "pep.mapper.classes";
    private String issuer;
    private String subjectIdURI = XACML3.ID_SUBJECT_SUBJECT_ID.stringValue();
    private String actionIdURI = XACML3.ID_ACTION_ACTION_ID.stringValue();
    private String resourceIdURI = XACML3.ID_RESOURCE_RESOURCE_ID.stringValue();
    private PepResponseBehavior indeterminateBehavior = PepResponseBehavior.THROW_EXCEPTION;
    private PepResponseBehavior notApplicableBehavior = PepResponseBehavior.RETURN_NO;
    private List<String> mapperClassNames = Collections.emptyList();

    public StdPepConfig() {
    }

    public StdPepConfig(Properties properties) {
        this();
        String mapperClassNameString;
        String notapplicableString;
        String indeterminateString;
        String resourceIdURI;
        String actionIdURI;
        this.issuer = properties.getProperty(PEP_ISSUER);
        String subjectIdURI = properties.getProperty(PEP_DEFAULT_SUBJECT_ID);
        if (!StringUtils.isEmpty((CharSequence)subjectIdURI)) {
            this.subjectIdURI = subjectIdURI;
        }
        if (!StringUtils.isEmpty((CharSequence)(actionIdURI = properties.getProperty(PEP_DEFAULT_ACTION_ID)))) {
            this.actionIdURI = actionIdURI;
        }
        if (!StringUtils.isEmpty((CharSequence)(resourceIdURI = properties.getProperty(PEP_DEFAULT_RESOURCE_ID)))) {
            this.resourceIdURI = resourceIdURI;
        }
        if (!StringUtils.isEmpty((CharSequence)(indeterminateString = properties.getProperty(PEP_INDETERMINATE_BEHAVIOR)))) {
            PepResponseBehavior indeterminateBehavior = PepResponseBehavior.valueOf(indeterminateString);
            if (indeterminateBehavior == null) {
                logger.error((Object)"Invalid indeterminate behavior found in configuration.");
            }
            this.indeterminateBehavior = indeterminateBehavior;
        }
        if (!StringUtils.isEmpty((CharSequence)(notapplicableString = properties.getProperty(PEP_NOTAPPLICABLE_BEHAVIOR)))) {
            PepResponseBehavior notApplicableBehavior = PepResponseBehavior.valueOf(notapplicableString);
            if (notApplicableBehavior == null) {
                logger.error((Object)"Invalid notapplicable behavior found in configuration.");
            }
            this.notApplicableBehavior = notApplicableBehavior;
        }
        if (!StringUtils.isEmpty((CharSequence)(mapperClassNameString = properties.getProperty(PEP_MAPPER_CLASSES)))) {
            ArrayList<String> mapperClassNames = new ArrayList<String>();
            for (String className : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)mapperClassNameString)) {
                mapperClassNames.add(className);
            }
            this.mapperClassNames = Collections.unmodifiableList(mapperClassNames);
        }
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public String getDefaultSubjectId() {
        return this.subjectIdURI;
    }

    @Override
    public String getDefaultResourceId() {
        return this.resourceIdURI;
    }

    @Override
    public String getDefaultActionId() {
        return this.actionIdURI;
    }

    @Override
    public PepResponseBehavior getIndeterminateBehavior() {
        return this.indeterminateBehavior;
    }

    @Override
    public PepResponseBehavior getNotApplicableBehavior() {
        return this.notApplicableBehavior;
    }

    @Override
    public List<String> getMapperClassNames() {
        return this.mapperClassNames;
    }
}

