/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi.std;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.pepapi.Advice;
import org.apache.openaz.pepapi.Obligation;
import org.apache.openaz.pepapi.ObligationRouter;
import org.apache.openaz.pepapi.PepConfig;
import org.apache.openaz.pepapi.PepException;
import org.apache.openaz.pepapi.PepResponse;
import org.apache.openaz.pepapi.PepResponseBehavior;
import org.apache.openaz.pepapi.std.StdAdvice;
import org.apache.openaz.pepapi.std.StdObligation;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeCategory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Result;
import org.apache.openaz.xacml.api.Status;

final class StdPepResponse
implements PepResponse {
    private static final Log logger = LogFactory.getLog(StdPepResponse.class);
    private final Result wrappedResult;
    private final PepConfig pepConfig;
    private final ObligationRouter obligationRouter;

    static PepResponse newInstance(PepConfig pepConfig, ObligationRouter obligationRouter, Result result) {
        return new StdPepResponse(pepConfig, obligationRouter, result);
    }

    private StdPepResponse(PepConfig pepConfig, ObligationRouter obligationRouter, Result result) {
        this.pepConfig = pepConfig;
        this.wrappedResult = result;
        this.obligationRouter = obligationRouter;
    }

    @Override
    public boolean allowed() throws PepException {
        if (this.obligationRouter != null) {
            this.obligationRouter.routeObligations(this.getObligations());
        }
        switch (this.wrappedResult.getDecision()) {
            case PERMIT: {
                return true;
            }
            case DENY: {
                return false;
            }
            case NOTAPPLICABLE: {
                return this.enforceBehavior(this.pepConfig.getNotApplicableBehavior(), "Not Applicable");
            }
            case INDETERMINATE: 
            case INDETERMINATE_DENY: 
            case INDETERMINATE_DENYPERMIT: 
            case INDETERMINATE_PERMIT: {
                Status status = this.wrappedResult.getStatus();
                String formatted = String.format("Decision: Indeterminate, Status Code: %s, Status Message: %s", status.getStatusCode(), status.getStatusMessage());
                logger.error((Object)formatted);
                throw new PepException(formatted);
            }
        }
        throw new PepException("Invalid response from PDP");
    }

    @Override
    public Map<String, Obligation> getObligations() throws PepException {
        HashMap<String, Obligation> obligationMap = new HashMap<String, Obligation>();
        for (org.apache.openaz.xacml.api.Obligation wrappedObligation : this.wrappedResult.getObligations()) {
            StdObligation obligation = new StdObligation(wrappedObligation);
            obligationMap.put(obligation.getId(), obligation);
        }
        return obligationMap;
    }

    @Override
    public Map<String, Advice> getAdvices() throws PepException {
        HashMap<String, Advice> adviceMap = new HashMap<String, Advice>();
        for (org.apache.openaz.xacml.api.Advice wrappedAdvice : this.wrappedResult.getAssociatedAdvice()) {
            StdAdvice advice = new StdAdvice(wrappedAdvice);
            adviceMap.put(advice.getId(), advice);
        }
        return adviceMap;
    }

    @Override
    public Object getAssociation() throws PepException {
        return null;
    }

    @Override
    public Collection<Attribute> getAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (AttributeCategory category : this.wrappedResult.getAttributes()) {
            attributes.addAll(category.getAttributes());
        }
        return attributes;
    }

    @Override
    public Map<Identifier, Collection<Attribute>> getAttributesByCategory() {
        HashMap<Identifier, Collection<Attribute>> attributesByCategory = new HashMap<Identifier, Collection<Attribute>>();
        for (AttributeCategory category : this.wrappedResult.getAttributes()) {
            attributesByCategory.put(category.getCategory(), category.getAttributes());
        }
        return attributesByCategory;
    }

    @Override
    public Result getWrappedResult() {
        return this.wrappedResult;
    }

    private boolean enforceBehavior(PepResponseBehavior pepResponseBehavior, String decision) throws PepException {
        switch (pepResponseBehavior) {
            case RETURN_YES: {
                return true;
            }
            case RETURN_NO: {
                return false;
            }
            case THROW_EXCEPTION: {
                logger.info((Object)("Throwing an exception as per configured behavior for decision: " + decision));
                throw new PepException("Exception being thrown based on configured behavior for decision: " + decision);
            }
        }
        throw new PepException("Invalid PepResponseBehavior");
    }
}

