/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.MatchResult;
import org.apache.openaz.xacml.pdp.eval.Matchable;
import org.apache.openaz.xacml.pdp.policy.AllOf;
import org.apache.openaz.xacml.pdp.policy.PolicyComponent;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.util.StringUtils;

public class AnyOf
extends PolicyComponent
implements Matchable {
    private List<AllOf> allOfs;

    protected List<AllOf> getAllOfList(boolean bNoNull) {
        if (this.allOfs == null && bNoNull) {
            this.allOfs = new ArrayList<AllOf>();
        }
        return this.allOfs;
    }

    protected void clearAllOfList() {
        if (this.allOfs != null) {
            this.allOfs.clear();
        }
    }

    public AnyOf(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public AnyOf(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public AnyOf() {
    }

    public AnyOf(Collection<AllOf> allOfsIn) {
        if (allOfsIn != null) {
            this.addAllOfs(allOfsIn);
        }
    }

    public Iterator<AllOf> getAllOfs() {
        return this.allOfs == null ? null : this.allOfs.iterator();
    }

    public void setAllOfs(Collection<AllOf> allOfsIn) {
        this.clearAllOfList();
        if (allOfsIn != null) {
            this.addAllOfs(allOfsIn);
        }
    }

    public void addAllOf(AllOf allOf) {
        List<AllOf> listAllOfs = this.getAllOfList(true);
        listAllOfs.add(allOf);
    }

    public void addAllOfs(Collection<AllOf> allOfs) {
        List<AllOf> listAllOfs = this.getAllOfList(true);
        listAllOfs.addAll(allOfs);
    }

    @Override
    public MatchResult match(EvaluationContext evaluationContext) throws EvaluationException {
        if (!this.validate()) {
            return new MatchResult((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        Iterator<AllOf> iterAllOfs = this.getAllOfs();
        if (iterAllOfs == null || !iterAllOfs.hasNext()) {
            return MatchResult.MM_NOMATCH;
        }
        MatchResult matchResultFallThrough = MatchResult.MM_NOMATCH;
        while (iterAllOfs.hasNext()) {
            MatchResult matchResultAllOf = iterAllOfs.next().match(evaluationContext);
            assert (matchResultAllOf != null);
            switch (matchResultAllOf.getMatchCode()) {
                case INDETERMINATE: {
                    if (matchResultFallThrough.getMatchCode() == MatchResult.MatchCode.INDETERMINATE) break;
                    matchResultFallThrough = matchResultAllOf;
                    break;
                }
                case MATCH: {
                    return matchResultAllOf;
                }
            }
        }
        return matchResultFallThrough;
    }

    @Override
    protected boolean validateComponent() {
        Iterator<AllOf> iterAllOfs = this.getAllOfs();
        if (iterAllOfs == null || !iterAllOfs.hasNext()) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing AllOf elements in AnyOf");
            return false;
        }
        this.setStatus(StdStatusCode.STATUS_CODE_OK, null);
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        String iterToDump = StringUtils.toString(this.getAllOfs());
        if (iterToDump != null) {
            stringBuilder.append(",allOfs=");
            stringBuilder.append(iterToDump);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

