/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.api.trace.TraceEvent;
import org.apache.openaz.xacml.api.trace.Traceable;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.EvaluationResult;
import org.apache.openaz.xacml.pdp.eval.MatchResult;
import org.apache.openaz.xacml.pdp.policy.CombiningAlgorithm;
import org.apache.openaz.xacml.pdp.policy.CombiningElement;
import org.apache.openaz.xacml.pdp.policy.PolicyDef;
import org.apache.openaz.xacml.pdp.policy.PolicySetChild;
import org.apache.openaz.xacml.pdp.policy.TargetedCombinerParameter;
import org.apache.openaz.xacml.pdp.policy.TargetedCombinerParameterMap;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.trace.StdTraceEvent;
import org.apache.openaz.xacml.util.StringUtils;

public class PolicySet
extends PolicyDef {
    private TargetedCombinerParameterMap<Identifier, PolicySetChild> policyCombinerParameters = new TargetedCombinerParameterMap();
    private List<PolicySetChild> children;
    private List<CombiningElement<PolicySetChild>> combiningPolicies;
    private CombiningAlgorithm<PolicySetChild> combiningAlgorithm;

    private void ensureChildren() {
        if (this.children == null) {
            this.children = new ArrayList<PolicySetChild>();
        }
    }

    protected List<CombiningElement<PolicySetChild>> getCombiningPolicies() {
        if (this.combiningPolicies == null) {
            this.combiningPolicies = new ArrayList<CombiningElement<PolicySetChild>>();
            Iterator<PolicySetChild> iterPolicies = this.getChildren();
            if (iterPolicies != null) {
                while (iterPolicies.hasNext()) {
                    PolicySetChild policySetChild = iterPolicies.next();
                    this.combiningPolicies.add(new CombiningElement<PolicySetChild>(policySetChild, this.policyCombinerParameters.getCombinerParameters(policySetChild)));
                }
            }
        }
        return this.combiningPolicies;
    }

    @Override
    protected boolean validateComponent() {
        if (super.validateComponent()) {
            if (this.getPolicyCombiningAlgorithm() == null) {
                this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing policy combining algorithm");
                return false;
            }
            return true;
        }
        return false;
    }

    public PolicySet(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public PolicySet(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public PolicySet(PolicySet policySetParent) {
        super(policySetParent);
    }

    public PolicySet() {
    }

    public Iterator<TargetedCombinerParameter<Identifier, PolicySetChild>> getPolicyCombinerParameters() {
        return this.policyCombinerParameters.getTargetedCombinerParameters();
    }

    public void setPolicyCombinerParameters(Collection<TargetedCombinerParameter<Identifier, PolicySetChild>> policyCombinerParametersIn) {
        this.policyCombinerParameters.setCombinerParameters(policyCombinerParametersIn);
    }

    public void addPolicyCombinerParameter(TargetedCombinerParameter<Identifier, PolicySetChild> policyCombinerParameter) {
        this.policyCombinerParameters.addCombinerParameter(policyCombinerParameter);
    }

    public void addPolicyCombinerParameters(Collection<TargetedCombinerParameter<Identifier, PolicySetChild>> policyCombinerParametersIn) {
        this.policyCombinerParameters.addCombinerParameters(policyCombinerParametersIn);
    }

    public Iterator<PolicySetChild> getChildren() {
        return this.children == null ? null : this.children.iterator();
    }

    public void setChildren(Collection<PolicySetChild> policySetChildren) {
        this.children = null;
        if (policySetChildren != null) {
            this.addChildren(policySetChildren);
        }
    }

    public void addChild(PolicySetChild policySetChild) {
        this.ensureChildren();
        this.children.add(policySetChild);
    }

    public void addChildren(Collection<PolicySetChild> policySetChildren) {
        this.ensureChildren();
        this.children.addAll(policySetChildren);
    }

    public CombiningAlgorithm<PolicySetChild> getPolicyCombiningAlgorithm() {
        return this.combiningAlgorithm;
    }

    public void setPolicyCombiningAlgorithm(CombiningAlgorithm<PolicySetChild> combiningAlgorithmIn) {
        this.combiningAlgorithm = combiningAlgorithmIn;
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext evaluationContext) throws EvaluationException {
        if (evaluationContext.isTracing()) {
            evaluationContext.trace((TraceEvent)new StdTraceEvent("PolicySet", (Traceable)this, null));
        }
        if (!this.validate()) {
            return new EvaluationResult((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        MatchResult thisMatchResult = this.match(evaluationContext);
        assert (thisMatchResult != null);
        if (evaluationContext.isTracing()) {
            evaluationContext.trace((TraceEvent)new StdTraceEvent("Match", (Traceable)this, (Object)thisMatchResult));
        }
        switch (thisMatchResult.getMatchCode()) {
            case INDETERMINATE: {
                return new EvaluationResult(Decision.INDETERMINATE, thisMatchResult.getStatus());
            }
            case MATCH: {
                break;
            }
            case NOMATCH: {
                return new EvaluationResult(Decision.NOTAPPLICABLE);
            }
        }
        List listCombiningElements = this.getCombiningPolicies();
        assert (listCombiningElements != null);
        assert (this.getPolicyCombiningAlgorithm() != null);
        EvaluationResult evaluationResultCombined = this.getPolicyCombiningAlgorithm().combine(evaluationContext, listCombiningElements, this.getCombinerParameterList());
        assert (evaluationResultCombined != null);
        if (evaluationContext.getRequest().getReturnPolicyIdList()) {
            evaluationResultCombined.addPolicySetIdentifier(this.getIdReference());
        }
        if (evaluationResultCombined.getDecision() == Decision.DENY || evaluationResultCombined.getDecision() == Decision.PERMIT) {
            this.updateResult(evaluationResultCombined, evaluationContext);
        }
        if (evaluationContext.isTracing()) {
            evaluationContext.trace((TraceEvent)new StdTraceEvent("Result", (Traceable)this, (Object)evaluationResultCombined));
        }
        return evaluationResultCombined;
    }

    @Override
    public String toString() {
        CombiningAlgorithm<PolicySetChild> objectToDump;
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        String iteratorToDump = StringUtils.toString(this.getPolicyCombinerParameters());
        if (iteratorToDump != null) {
            stringBuilder.append(",policyCombinerParameters=");
            stringBuilder.append(iteratorToDump);
        }
        if ((iteratorToDump = StringUtils.toString(this.getChildren())) != null) {
            stringBuilder.append(",children=");
            stringBuilder.append(iteratorToDump);
        }
        if ((objectToDump = this.getPolicyCombiningAlgorithm()) != null) {
            stringBuilder.append(",policyCombiningAlgorithm=");
            stringBuilder.append(objectToDump.toString());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public String getTraceId() {
        return this.getIdentifier().stringValue();
    }

    @Override
    public Traceable getCause() {
        return null;
    }
}

