/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.MatchResult;
import org.apache.openaz.xacml.pdp.eval.Matchable;
import org.apache.openaz.xacml.pdp.policy.AnyOf;
import org.apache.openaz.xacml.pdp.policy.PolicyComponent;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.util.StringUtils;

public class Target
extends PolicyComponent
implements Matchable {
    private List<AnyOf> anyOfs;

    protected List<AnyOf> getAnyOfList(boolean bNoNull) {
        if (this.anyOfs == null && bNoNull) {
            this.anyOfs = new ArrayList<AnyOf>();
        }
        return this.anyOfs;
    }

    protected void clearAnyOfList() {
        if (this.anyOfs != null) {
            this.anyOfs.clear();
        }
    }

    public Target(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public Target(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public Target() {
    }

    public Target(Collection<AnyOf> anyOfsIn) {
        if (anyOfsIn != null) {
            this.addAnyOfs(anyOfsIn);
        }
    }

    public Target(AnyOf anyOfIn) {
        if (anyOfIn != null) {
            this.addAnyOf(anyOfIn);
        }
    }

    public Iterator<AnyOf> getAnyOfs() {
        return this.anyOfs == null ? null : this.anyOfs.iterator();
    }

    public void setAnyOfs(Collection<AnyOf> anyOfsIn) {
        this.clearAnyOfList();
        if (anyOfsIn != null) {
            this.addAnyOfs(anyOfsIn);
        }
    }

    public void addAnyOf(AnyOf anyOfIn) {
        List<AnyOf> listAnyOfs = this.getAnyOfList(true);
        listAnyOfs.add(anyOfIn);
    }

    public void addAnyOfs(Collection<AnyOf> anyOfsIn) {
        List<AnyOf> listAnyOfs = this.getAnyOfList(true);
        listAnyOfs.addAll(anyOfsIn);
    }

    @Override
    public MatchResult match(EvaluationContext evaluationContext) throws EvaluationException {
        if (!this.validate()) {
            return new MatchResult((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        Iterator<AnyOf> iterAnyOfs = this.getAnyOfs();
        if (iterAnyOfs == null || !iterAnyOfs.hasNext()) {
            return MatchResult.MM_MATCH;
        }
        MatchResult matchResult = MatchResult.MM_MATCH;
        while (iterAnyOfs.hasNext()) {
            matchResult = iterAnyOfs.next().match(evaluationContext);
            if (matchResult.getMatchCode() == MatchResult.MatchCode.MATCH) continue;
            return matchResult;
        }
        return matchResult;
    }

    @Override
    protected boolean validateComponent() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        String iterToDump = StringUtils.toString(this.getAnyOfs());
        if (iterToDump != null) {
            stringBuilder.append(",anyOfs=");
            stringBuilder.append(iterToDump);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

