/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.pdp.policy.AdviceExpression;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.RuleEffect;
import org.apache.openaz.xacml.pdp.policy.dom.DOMAttributeAssignmentExpression;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMAdviceExpression
extends AdviceExpression {
    private static final Log logger = LogFactory.getLog(DOMAdviceExpression.class);

    protected DOMAdviceExpression() {
    }

    public static AdviceExpression newInstance(Node nodeAdviceExpression, Policy policy) throws DOMStructureException {
        DOMAdviceExpression domAdviceExpression;
        block6: {
            Element elementAdviceExpression = DOMUtil.getElement((Node)nodeAdviceExpression);
            boolean bLenient = DOMProperties.isLenient();
            domAdviceExpression = new DOMAdviceExpression();
            try {
                int numChildren;
                NodeList children = elementAdviceExpression.getChildNodes();
                if (children != null && (numChildren = children.getLength()) > 0) {
                    for (int i = 0; i < numChildren; ++i) {
                        Node child = children.item(i);
                        if (!DOMUtil.isElement((Node)child)) continue;
                        if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AttributeAssignmentExpression".equals(child.getLocalName())) {
                            domAdviceExpression.addAttributeAssignmentExpression(DOMAttributeAssignmentExpression.newInstance(child, policy));
                            continue;
                        }
                        if (bLenient) continue;
                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeAdviceExpression);
                    }
                }
                domAdviceExpression.setAdviceId(DOMUtil.getIdentifierAttribute((Node)elementAdviceExpression, (String)"AdviceId", (!bLenient ? 1 : 0) != 0));
                String string = DOMUtil.getStringAttribute((Node)elementAdviceExpression, (String)"AppliesTo", (!bLenient ? 1 : 0) != 0);
                RuleEffect ruleEffect = RuleEffect.getRuleEffect(string);
                if (ruleEffect == null && !bLenient) {
                    throw new DOMStructureException(nodeAdviceExpression, "Unknown EffectType \"" + string + "\"");
                }
                domAdviceExpression.setAppliesTo(ruleEffect);
            }
            catch (DOMStructureException ex) {
                domAdviceExpression.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block6;
                throw ex;
            }
        }
        return domAdviceExpression;
    }

    public static boolean repair(Node nodeAdviceExpression) throws DOMStructureException {
        int numChildren;
        Element elementAdviceExpression = DOMUtil.getElement((Node)nodeAdviceExpression);
        boolean result = false;
        NodeList children = elementAdviceExpression.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AttributeAssignmentExpression".equals(child.getLocalName())) {
                    result = DOMAttributeAssignmentExpression.repair(child) || result;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                nodeAdviceExpression.removeChild(child);
                result = true;
            }
        }
        result = DOMUtil.repairIdentifierAttribute((Element)elementAdviceExpression, (String)"AdviceId", (Log)logger) || result;
        result = DOMUtil.repairStringAttribute((Element)elementAdviceExpression, (String)"AppliesTo", (String)RuleEffect.DENY.getName(), (Log)logger) || result;
        String stringRuleEffect = DOMUtil.getStringAttribute((Node)elementAdviceExpression, (String)"AppliesTo");
        RuleEffect ruleEffect = RuleEffect.getRuleEffect(stringRuleEffect);
        if (ruleEffect == null) {
            logger.warn((Object)("Setting invalid RuleEffect " + stringRuleEffect + " to " + RuleEffect.DENY.getName()));
            elementAdviceExpression.setAttribute("AppliesTo", RuleEffect.DENY.getName());
            result = true;
        }
        return result;
    }

    public static List<AdviceExpression> newList(Node nodeAdviceExpressions, Policy policy) throws DOMStructureException {
        int numChildren;
        Element elementAdviceExpressions = DOMUtil.getElement((Node)nodeAdviceExpressions);
        boolean bLenient = DOMProperties.isLenient();
        ArrayList<AdviceExpression> listAdviceExpressions = new ArrayList<AdviceExpression>();
        NodeList children = elementAdviceExpressions.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AdviceExpression".equals(child.getLocalName())) {
                    listAdviceExpressions.add(DOMAdviceExpression.newInstance(child, policy));
                    continue;
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeAdviceExpressions);
            }
        }
        if (listAdviceExpressions.size() == 0 && !bLenient) {
            throw DOMUtil.newMissingElementException((Node)nodeAdviceExpressions, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"AdviceExpression");
        }
        return listAdviceExpressions;
    }

    public static boolean repairList(Node nodeAdviceExpressions) throws DOMStructureException {
        int numChildren;
        Element elementAdviceExpressions = DOMUtil.getElement((Node)nodeAdviceExpressions);
        boolean result = false;
        boolean sawAdviceExpression = false;
        NodeList children = elementAdviceExpressions.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AdviceExpression".equals(child.getLocalName())) {
                    sawAdviceExpression = true;
                    result = result || DOMAdviceExpression.repair(child);
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                nodeAdviceExpressions.removeChild(child);
                result = true;
            }
        }
        if (!sawAdviceExpression) {
            throw DOMUtil.newMissingElementException((Node)nodeAdviceExpressions, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"AdviceExpression");
        }
        return result;
    }
}

