/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.pdp.policy.ObligationExpression;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.RuleEffect;
import org.apache.openaz.xacml.pdp.policy.dom.DOMAttributeAssignmentExpression;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMObligationExpression
extends ObligationExpression {
    private static final Log logger = LogFactory.getLog(DOMObligationExpression.class);

    protected DOMObligationExpression() {
    }

    public static ObligationExpression newInstance(Node nodeObligationExpression, Policy policy) throws DOMStructureException {
        DOMObligationExpression domObligationExpression;
        block8: {
            Element elementObligationExpression = DOMUtil.getElement((Node)nodeObligationExpression);
            boolean bLenient = DOMProperties.isLenient();
            domObligationExpression = new DOMObligationExpression();
            try {
                int numChildren;
                NodeList children = elementObligationExpression.getChildNodes();
                if (children != null && (numChildren = children.getLength()) > 0) {
                    for (int i = 0; i < numChildren; ++i) {
                        Node child = children.item(i);
                        if (!DOMUtil.isElement((Node)child)) continue;
                        if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AttributeAssignmentExpression".equals(child.getLocalName())) {
                            domObligationExpression.addAttributeAssignmentExpression(DOMAttributeAssignmentExpression.newInstance(child, policy));
                            continue;
                        }
                        if (bLenient) continue;
                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeObligationExpression);
                    }
                }
                domObligationExpression.setObligationId(DOMUtil.getIdentifierAttribute((Node)elementObligationExpression, (String)"ObligationId", (!bLenient ? 1 : 0) != 0));
                String string = DOMUtil.getStringAttribute((Node)elementObligationExpression, (String)"FulfillOn", (!bLenient ? 1 : 0) != 0);
                RuleEffect ruleEffectType = RuleEffect.getRuleEffect(string);
                if (ruleEffectType == null) {
                    if (!bLenient) {
                        throw new DOMStructureException(nodeObligationExpression, "Invalid EffectType \"" + string + "\" in \"" + DOMUtil.getNodeLabel((Node)nodeObligationExpression) + "\"");
                    }
                } else {
                    domObligationExpression.setRuleEffect(ruleEffectType);
                }
            }
            catch (DOMStructureException ex) {
                domObligationExpression.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block8;
                throw ex;
            }
        }
        return domObligationExpression;
    }

    public static boolean repair(Node nodeObligationExpression) throws DOMStructureException {
        int numChildren;
        Element elementObligationExpression = DOMUtil.getElement((Node)nodeObligationExpression);
        boolean result = false;
        NodeList children = elementObligationExpression.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AttributeAssignmentExpression".equals(child.getLocalName())) {
                    result = DOMAttributeAssignmentExpression.repair(child) || result;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementObligationExpression.removeChild(child);
                result = true;
            }
        }
        result = DOMUtil.repairIdentifierAttribute((Element)elementObligationExpression, (String)"ObligationId", (Log)logger) || result;
        result = DOMUtil.repairStringAttribute((Element)elementObligationExpression, (String)"FulfillOn", (String)RuleEffect.DENY.getName(), (Log)logger) || result;
        String string = DOMUtil.getStringAttribute((Node)elementObligationExpression, (String)"FulfillOn");
        RuleEffect ruleEffectType = RuleEffect.getRuleEffect(string);
        if (ruleEffectType == null) {
            logger.warn((Object)("Setting invalid RuleEffect " + string + " to " + RuleEffect.DENY.getName()));
            elementObligationExpression.setAttribute("FulfillOn", RuleEffect.DENY.getName());
            result = true;
        }
        return result;
    }

    public static List<ObligationExpression> newList(Node nodeObligationExpressions, Policy policy) throws DOMStructureException {
        int numChildren;
        Element elementObligationExpressions = DOMUtil.getElement((Node)nodeObligationExpressions);
        boolean bLenient = DOMProperties.isLenient();
        ArrayList<ObligationExpression> listObligationExpressions = new ArrayList<ObligationExpression>();
        NodeList children = elementObligationExpressions.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "ObligationExpression".equals(child.getLocalName())) {
                    listObligationExpressions.add(DOMObligationExpression.newInstance(child, policy));
                    continue;
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException((Node)child, (Node)elementObligationExpressions);
            }
        }
        if (listObligationExpressions.size() == 0 && !bLenient) {
            throw DOMUtil.newMissingElementException((Node)elementObligationExpressions, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"ObligationExpression");
        }
        return listObligationExpressions;
    }

    public static boolean repairList(Node nodeObligationExpressions) throws DOMStructureException {
        int numChildren;
        Element elementObligationExpressions = DOMUtil.getElement((Node)nodeObligationExpressions);
        boolean result = false;
        boolean sawObligationExpression = false;
        NodeList children = elementObligationExpressions.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "ObligationExpression".equals(child.getLocalName())) {
                    result = DOMObligationExpression.repair(child) || result;
                    sawObligationExpression = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementObligationExpressions.removeChild(child);
                result = true;
            }
        }
        if (!sawObligationExpression) {
            throw DOMUtil.newMissingElementException((Node)elementObligationExpressions, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"ObligationExpression");
        }
        return result;
    }
}

