/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.pdp.policy.PolicyIssuer;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMAttribute;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMPolicyIssuer
extends PolicyIssuer {
    private static Log logger = LogFactory.getLog(DOMPolicyIssuer.class);
    private static Identifier identifierCategoryPolicyIssuer = new IdentifierImpl("urn:att:names:tc:xacml:3.0:policy-issuer");

    protected DOMPolicyIssuer() {
    }

    public static PolicyIssuer newInstance(Node nodePolicyIssuer) throws DOMStructureException {
        DOMPolicyIssuer domPolicyIssuer;
        block7: {
            Element elementPolicyIssuer = DOMUtil.getElement((Node)nodePolicyIssuer);
            boolean bLenient = DOMProperties.isLenient();
            domPolicyIssuer = new DOMPolicyIssuer();
            try {
                int numChildren;
                NodeList children = elementPolicyIssuer.getChildNodes();
                if (children != null && (numChildren = children.getLength()) > 0) {
                    for (int i = 0; i < numChildren; ++i) {
                        Node child = children.item(i);
                        if (!DOMUtil.isElement((Node)child) || !DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) continue;
                        String childName = child.getLocalName();
                        if ("Content".equals(childName)) {
                            if (domPolicyIssuer.getContent() != null && !bLenient) {
                                throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicyIssuer);
                            }
                            domPolicyIssuer.setContent(child);
                            continue;
                        }
                        if ("Attribute".equals(childName)) {
                            domPolicyIssuer.add(DOMAttribute.newInstance((Identifier)identifierCategoryPolicyIssuer, (Node)child));
                            continue;
                        }
                        if (bLenient) continue;
                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicyIssuer);
                    }
                }
            }
            catch (DOMStructureException ex) {
                domPolicyIssuer.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block7;
                throw ex;
            }
        }
        return domPolicyIssuer;
    }

    public static boolean repair(Node nodePolicyIssuer) throws DOMStructureException {
        int numChildren;
        Element elementPolicyIssuer = DOMUtil.getElement((Node)nodePolicyIssuer);
        boolean result = false;
        boolean sawContent = false;
        NodeList children = elementPolicyIssuer.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child) || !DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) continue;
                String childName = child.getLocalName();
                if ("Content".equals(childName)) {
                    if (sawContent) {
                        logger.warn((Object)("Unexpected element " + child.getNodeName()));
                        elementPolicyIssuer.removeChild(child);
                        result = true;
                        continue;
                    }
                    sawContent = true;
                    continue;
                }
                if ("Attribute".equals(childName)) {
                    result = DOMAttribute.repair((Node)child) || result;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementPolicyIssuer.removeChild(child);
                result = true;
            }
        }
        return result;
    }
}

