/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.expressions;

import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.api.StatusDetail;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.pdp.policy.Expression;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

public abstract class AttributeRetrievalBase
extends Expression {
    private Identifier category;
    private Identifier dataTypeId;
    private Boolean mustBePresent;

    protected AttributeRetrievalBase(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    protected AttributeRetrievalBase(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    protected AttributeRetrievalBase() {
    }

    protected AttributeRetrievalBase(Identifier categoryIn, Identifier dataTypeIdIn, Boolean mustBePresentIn) {
        this.category = categoryIn;
        this.dataTypeId = dataTypeIdIn;
        this.mustBePresent = mustBePresentIn;
    }

    public Identifier getCategory() {
        return this.category;
    }

    public void setCategory(Identifier categoryIn) {
        this.category = categoryIn;
    }

    public Identifier getDataTypeId() {
        return this.dataTypeId;
    }

    public void setDataTypeId(Identifier dataTypeIn) {
        if (dataTypeIn.equals((Object)XACML.ID_DATATYPE_WD_DAYTIMEDURATION)) {
            dataTypeIn = DataTypes.DT_DAYTIMEDURATION.getId();
        } else if (dataTypeIn.equals((Object)XACML.ID_DATATYPE_WD_YEARMONTHDURATION)) {
            dataTypeIn = DataTypes.DT_YEARMONTHDURATION.getId();
        }
        this.dataTypeId = dataTypeIn;
    }

    public Boolean getMustBePresent() {
        return this.mustBePresent;
    }

    public void setMustBePresent(boolean b) {
        this.mustBePresent = b;
    }

    @Override
    protected boolean validateComponent() {
        if (this.getCategory() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing Category");
            return false;
        }
        if (this.getDataTypeId() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing DataType");
            return false;
        }
        if (this.getMustBePresent() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing MustBePresent");
            return false;
        }
        this.setStatus(StdStatusCode.STATUS_CODE_OK, null);
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        Object objectToDump = this.getCategory();
        if (objectToDump != null) {
            stringBuilder.append(",category=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getDataTypeId()) != null) {
            stringBuilder.append(",dataType=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getMustBePresent()) != null) {
            stringBuilder.append(",mustBePresent=");
            stringBuilder.append(objectToDump.toString());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    protected ExpressionResult getEmptyResult(String statusMessage, StatusDetail statusDetail) {
        if (this.getMustBePresent() != null && this.getMustBePresent().booleanValue()) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_MISSING_ATTRIBUTE, statusMessage, statusDetail));
        }
        return ExpressionResult.newEmpty();
    }
}

