/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.expressions;

import java.net.URI;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.policy.Expression;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.PolicyDefaults;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

public class Function
extends Expression {
    private Identifier functionId;
    private AttributeValue<URI> attributeValue;
    private ExpressionResult expressionResultOk;

    protected ExpressionResult getExpressionResultOk() {
        if (this.expressionResultOk == null) {
            this.expressionResultOk = ExpressionResult.newSingle(this.getAttributeValue());
        }
        return this.expressionResultOk;
    }

    public Function(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public Function(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public Function() {
    }

    public Function(Identifier functionIdIn) {
        this.functionId = functionIdIn;
    }

    public Identifier getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(Identifier identifier) {
        this.functionId = identifier;
        this.attributeValue = null;
        this.expressionResultOk = null;
    }

    public AttributeValue<URI> getAttributeValue() {
        Identifier thisFunctionId;
        if (this.attributeValue == null && (thisFunctionId = this.getFunctionId()) != null) {
            try {
                this.attributeValue = DataTypes.DT_ANYURI.createAttributeValue((Object)thisFunctionId);
            }
            catch (DataTypeException ex) {
                this.attributeValue = null;
            }
        }
        return this.attributeValue;
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, PolicyDefaults policyDefaults) throws EvaluationException {
        if (!this.validate()) {
            return ExpressionResult.newError((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        return this.getExpressionResultOk();
    }

    @Override
    protected boolean validateComponent() {
        if (this.getFunctionId() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing FunctionId");
            return false;
        }
        this.setStatus(StdStatusCode.STATUS_CODE_OK, null);
        return true;
    }
}

