/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.expressions;

import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.api.trace.TraceEvent;
import org.apache.openaz.xacml.api.trace.Traceable;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.policy.Expression;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.PolicyDefaults;
import org.apache.openaz.xacml.pdp.policy.VariableDefinition;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.trace.StdTraceEvent;

public class VariableReference
extends Expression
implements Traceable {
    private static final ExpressionResult ER_SE_NO_EXPRESSION = ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing Expression for VariableDefinition"));
    private Policy policy;
    private String variableId;
    private VariableDefinition variableDefinition;

    protected VariableDefinition getVariableDefinition() {
        String thisVariableId;
        Policy thisPolicy;
        if (this.variableDefinition == null && (thisPolicy = this.getPolicy()) != null && (thisVariableId = this.getVariableId()) != null) {
            this.variableDefinition = thisPolicy.getVariableDefinition(thisVariableId);
        }
        return this.variableDefinition;
    }

    public VariableReference(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public VariableReference(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public VariableReference() {
    }

    public VariableReference(Policy policyIn, String variableIdIn) {
        this.policy = policyIn;
        this.variableId = variableIdIn;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Policy policyIn) {
        this.policy = policyIn;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public void setVariableId(String variableIdIn) {
        this.variableId = variableIdIn;
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, PolicyDefaults policyDefaults) throws EvaluationException {
        if (!this.validate()) {
            return ExpressionResult.newError((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        VariableDefinition variableDefinition = this.getVariableDefinition();
        if (variableDefinition == null) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "No VariableDefinition found for \"" + this.getVariableId() + "\""));
        }
        Expression expression = variableDefinition.getExpression();
        if (expression == null) {
            return ER_SE_NO_EXPRESSION;
        }
        ExpressionResult result = expression.evaluate(evaluationContext, policyDefaults);
        if (evaluationContext.isTracing()) {
            evaluationContext.trace((TraceEvent)new StdTraceEvent("Variable", (Traceable)this, (Object)result));
        }
        return result;
    }

    @Override
    protected boolean validateComponent() {
        if (this.getVariableId() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing VariableId");
            return false;
        }
        if (this.getPolicy() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "VariableReference not in a Policy");
            return false;
        }
        this.setStatus(StdStatusCode.STATUS_CODE_OK, null);
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        String stringToDump = this.getVariableId();
        if (stringToDump != null) {
            stringBuilder.append(",variableId=");
            stringBuilder.append(stringToDump);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public String getTraceId() {
        return this.variableId;
    }

    public Traceable getCause() {
        return this.policy;
    }
}

