/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.pdp.policy.CombiningAlgorithm;
import org.apache.openaz.xacml.pdp.policy.CombiningAlgorithmFactory;
import org.apache.openaz.xacml.pdp.policy.PolicySetChild;
import org.apache.openaz.xacml.pdp.policy.Rule;
import org.apache.openaz.xacml.pdp.std.StdCombiningAlgorithms;

public class StdCombiningAlgorithmFactory
extends CombiningAlgorithmFactory {
    private static Map<Identifier, CombiningAlgorithm<Rule>> mapRuleCombiningAlgorithms = new HashMap<Identifier, CombiningAlgorithm<Rule>>();
    private static Map<Identifier, CombiningAlgorithm<PolicySetChild>> mapPolicyCombiningAlgorithms = new HashMap<Identifier, CombiningAlgorithm<PolicySetChild>>();
    private static boolean needInit = true;

    protected static void registerRuleCombiningAlgorithm(CombiningAlgorithm<Rule> ruleCombiningAlgorithm) {
        mapRuleCombiningAlgorithms.put(ruleCombiningAlgorithm.getId(), ruleCombiningAlgorithm);
    }

    protected static void registerPolicyCombiningAlgorithm(CombiningAlgorithm<PolicySetChild> policyCombiningAlgorithm) {
        mapPolicyCombiningAlgorithms.put(policyCombiningAlgorithm.getId(), policyCombiningAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMap() {
        if (needInit) {
            Map<Identifier, CombiningAlgorithm<Rule>> map = mapRuleCombiningAlgorithms;
            synchronized (map) {
                if (needInit) {
                    Field[] declaredFields;
                    needInit = false;
                    for (Field field : declaredFields = StdCombiningAlgorithms.class.getFields()) {
                        if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !field.getName().startsWith("CA_") || !CombiningAlgorithm.class.isAssignableFrom(field.getType())) continue;
                        try {
                            if (field.getName().startsWith("CA_RULE_")) {
                                StdCombiningAlgorithmFactory.registerRuleCombiningAlgorithm((CombiningAlgorithm)field.get(null));
                                continue;
                            }
                            if (!field.getName().startsWith("CA_POLICY_")) continue;
                            StdCombiningAlgorithmFactory.registerPolicyCombiningAlgorithm((CombiningAlgorithm)field.get(null));
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    public StdCombiningAlgorithmFactory() {
        StdCombiningAlgorithmFactory.initMap();
    }

    @Override
    public CombiningAlgorithm<Rule> getRuleCombiningAlgorithm(Identifier combiningAlgorithmId) {
        return mapRuleCombiningAlgorithms.get(combiningAlgorithmId);
    }

    @Override
    public CombiningAlgorithm<PolicySetChild> getPolicyCombiningAlgorithm(Identifier combiningAlgorithmId) {
        return mapPolicyCombiningAlgorithms.get(combiningAlgorithmId);
    }
}

