/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.IdReferenceMatch;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.Version;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.MatchResult;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.PolicyDef;
import org.apache.openaz.xacml.pdp.policy.PolicyFinder;
import org.apache.openaz.xacml.pdp.policy.PolicyFinderResult;
import org.apache.openaz.xacml.pdp.policy.PolicySet;
import org.apache.openaz.xacml.pdp.policy.PolicySetChild;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicyDef;
import org.apache.openaz.xacml.pdp.std.StdPolicyFinderResult;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;

public class StdPolicyFinder
implements PolicyFinder {
    private static final PolicyFinderResult<PolicyDef> PFR_MULTIPLE = new StdPolicyFinderResult<PolicyDef>((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Multiple applicable root policies"));
    private static final PolicyFinderResult<PolicyDef> PFR_NOT_FOUND = new StdPolicyFinderResult<PolicyDef>((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "No matching root policy found"));
    private static final PolicyFinderResult<Policy> PFR_POLICY_NOT_FOUND = new StdPolicyFinderResult<Policy>((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "No matching policy found"));
    private static final PolicyFinderResult<Policy> PFR_NOT_A_POLICY = new StdPolicyFinderResult<Policy>((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Not a policy"));
    private static final PolicyFinderResult<PolicySet> PFR_POLICYSET_NOT_FOUND = new StdPolicyFinderResult<PolicySet>((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "No matching policy set found"));
    private static final PolicyFinderResult<PolicySet> PFR_NOT_A_POLICYSET = new StdPolicyFinderResult<PolicySet>((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Not a policy set"));
    private Log logger = LogFactory.getLog(this.getClass());
    private List<PolicyDef> listRoots = new ArrayList<PolicyDef>();
    private Map<Identifier, List<PolicyDef>> mapPolicies = new HashMap<Identifier, List<PolicyDef>>();

    private void storeInPolicyMap(PolicyDef policyDef) {
        List<PolicyDef> listPolicyDefs = this.mapPolicies.get(policyDef.getIdentifier());
        if (listPolicyDefs == null) {
            listPolicyDefs = new ArrayList<PolicyDef>();
            this.mapPolicies.put(policyDef.getIdentifier(), listPolicyDefs);
        }
        listPolicyDefs.add(policyDef);
    }

    private <T extends PolicyDef> List<T> getFromPolicyMap(IdReferenceMatch idReferenceMatch, Class<T> classPolicyDef) {
        List<PolicyDef> listPolicyDefForId = this.mapPolicies.get(idReferenceMatch.getId());
        if (listPolicyDefForId == null) {
            return null;
        }
        ArrayList<T> listPolicyDefMatches = null;
        for (PolicyDef policyDef : listPolicyDefForId) {
            if (!classPolicyDef.isInstance(policyDef) || !policyDef.matches(idReferenceMatch)) continue;
            if (listPolicyDefMatches == null) {
                listPolicyDefMatches = new ArrayList<T>();
            }
            listPolicyDefMatches.add(classPolicyDef.cast(policyDef));
        }
        return listPolicyDefMatches;
    }

    private <T extends PolicyDef> T getBestMatchN(List<T> matches) {
        PolicyDef bestMatch = null;
        Version bestVersion = null;
        for (PolicyDef match : matches) {
            if (bestMatch == null) {
                bestMatch = match;
                bestVersion = match.getVersion();
                continue;
            }
            Version matchVersion = match.getVersion();
            if (matchVersion == null || matchVersion.compareTo((Object)bestVersion) <= 0) continue;
            bestMatch = match;
            bestVersion = matchVersion;
        }
        return (T)bestMatch;
    }

    private <T extends PolicyDef> T getBestMatch(List<T> matches) {
        switch (matches.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (T)((PolicyDef)matches.get(0));
            }
        }
        return this.getBestMatchN(matches);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PolicyDef loadPolicyDefFromURI(URI uri) throws StdPolicyFinderException {
        this.logger.info((Object)("Loading policy from URI " + uri.toString()));
        URL url = null;
        try {
            url = uri.toURL();
            this.logger.debug((Object)("Loading policy from URL " + url.toString()));
        }
        catch (MalformedURLException ex) {
            this.logger.debug((Object)("Unknown protocol for URI " + uri.toString()));
            return null;
        }
        try (InputStream inputStream = url.openStream();){
            PolicyDef policyDef = DOMPolicyDef.load(inputStream);
            return policyDef;
        }
        catch (Exception ex) {
            this.logger.error((Object)"Exception loading policy definition", (Throwable)ex);
            throw new StdPolicyFinderException("Exception loading policy def from \"" + uri.toString() + "\": " + ex.getMessage(), ex);
        }
    }

    private PolicyFinderResult<Policy> lookupPolicyByIdentifier(IdReferenceMatch idReferenceMatch) {
        URI uri;
        Identifier id;
        List<Policy> listCachedPolicies = this.getFromPolicyMap(idReferenceMatch, Policy.class);
        if (listCachedPolicies == null && (id = idReferenceMatch.getId()) != null && (uri = id.getUri()) != null && uri.isAbsolute()) {
            PolicyDef policyDef = null;
            try {
                policyDef = this.loadPolicyDefFromURI(uri);
            }
            catch (StdPolicyFinderException ex) {
                return new StdPolicyFinderResult<Policy>((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, ex.getMessage()));
            }
            if (policyDef != null) {
                if (policyDef instanceof Policy) {
                    ArrayList<PolicyDef> listPolicyDefs = new ArrayList<PolicyDef>();
                    listPolicyDefs.add(policyDef);
                    this.mapPolicies.put(id, listPolicyDefs);
                    this.mapPolicies.put(policyDef.getIdentifier(), listPolicyDefs);
                    return new StdPolicyFinderResult<Policy>((Policy)policyDef);
                }
                return PFR_NOT_A_POLICY;
            }
            return PFR_POLICY_NOT_FOUND;
        }
        if (listCachedPolicies != null) {
            return new StdPolicyFinderResult<Policy>(this.getBestMatch(listCachedPolicies));
        }
        return PFR_POLICY_NOT_FOUND;
    }

    private PolicyFinderResult<PolicySet> lookupPolicySetByIdentifier(IdReferenceMatch idReferenceMatch) {
        URI uri;
        Identifier id;
        List<PolicySet> listCachedPolicySets = this.getFromPolicyMap(idReferenceMatch, PolicySet.class);
        if (listCachedPolicySets == null && (id = idReferenceMatch.getId()) != null && (uri = id.getUri()) != null && uri.isAbsolute()) {
            PolicyDef policyDef = null;
            try {
                policyDef = this.loadPolicyDefFromURI(uri);
            }
            catch (StdPolicyFinderException ex) {
                return new StdPolicyFinderResult<PolicySet>((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, ex.getMessage()));
            }
            if (policyDef != null) {
                if (policyDef instanceof PolicySet) {
                    ArrayList<PolicyDef> listPolicyDefs = new ArrayList<PolicyDef>();
                    listPolicyDefs.add(policyDef);
                    this.mapPolicies.put(id, listPolicyDefs);
                    this.mapPolicies.put(policyDef.getIdentifier(), listPolicyDefs);
                    return new StdPolicyFinderResult<PolicySet>((PolicySet)policyDef);
                }
                return PFR_NOT_A_POLICYSET;
            }
            return PFR_POLICYSET_NOT_FOUND;
        }
        if (listCachedPolicySets != null) {
            return new StdPolicyFinderResult<PolicySet>(this.getBestMatch(listCachedPolicySets));
        }
        return PFR_POLICYSET_NOT_FOUND;
    }

    private void updatePolicyMap(PolicyDef policyDef) {
        Iterator<PolicySetChild> iterChildren;
        this.storeInPolicyMap(policyDef);
        if (policyDef instanceof PolicySet && (iterChildren = ((PolicySet)policyDef).getChildren()) != null) {
            while (iterChildren.hasNext()) {
                PolicySetChild policySetChild = iterChildren.next();
                if (!(policySetChild instanceof PolicyDef)) continue;
                this.updatePolicyMap((PolicyDef)policySetChild);
            }
        }
    }

    public StdPolicyFinder(Collection<PolicyDef> listRootPolicies, Collection<PolicyDef> referencedPolicyDefs) {
        if (listRootPolicies != null) {
            for (PolicyDef policyDef : listRootPolicies) {
                this.listRoots.add(policyDef);
                this.updatePolicyMap(policyDef);
            }
        }
        if (referencedPolicyDefs != null) {
            for (PolicyDef policyDef : referencedPolicyDefs) {
                this.storeInPolicyMap(policyDef);
            }
        }
    }

    public StdPolicyFinder(PolicyDef rootPolicyDef, Collection<PolicyDef> referencedPolicyDefs) {
        if (rootPolicyDef != null) {
            this.listRoots.add(rootPolicyDef);
            this.updatePolicyMap(rootPolicyDef);
        }
        if (referencedPolicyDefs != null) {
            for (PolicyDef policyDef : referencedPolicyDefs) {
                this.storeInPolicyMap(policyDef);
            }
        }
    }

    @Override
    public PolicyFinderResult<PolicyDef> getRootPolicyDef(EvaluationContext evaluationContext) {
        PolicyDef policyDefFirstMatch = null;
        Iterator<PolicyDef> iterRootPolicies = this.listRoots.iterator();
        StdPolicyFinderResult firstIndeterminate = null;
        while (iterRootPolicies.hasNext()) {
            PolicyDef policyDef = iterRootPolicies.next();
            MatchResult matchResult = null;
            try {
                matchResult = policyDef.match(evaluationContext);
                switch (matchResult.getMatchCode()) {
                    case INDETERMINATE: {
                        if (firstIndeterminate != null) break;
                        firstIndeterminate = new StdPolicyFinderResult(matchResult.getStatus());
                        break;
                    }
                    case MATCH: {
                        if (policyDefFirstMatch == null) {
                            policyDefFirstMatch = policyDef;
                            break;
                        }
                        return PFR_MULTIPLE;
                    }
                }
            }
            catch (EvaluationException ex) {
                if (firstIndeterminate != null) continue;
                firstIndeterminate = new StdPolicyFinderResult((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, ex.getMessage()));
            }
        }
        if (policyDefFirstMatch == null) {
            if (firstIndeterminate != null) {
                return firstIndeterminate;
            }
            return PFR_NOT_FOUND;
        }
        return new StdPolicyFinderResult<Object>(policyDefFirstMatch);
    }

    @Override
    public PolicyFinderResult<Policy> getPolicy(IdReferenceMatch idReferenceMatch) {
        return this.lookupPolicyByIdentifier(idReferenceMatch);
    }

    @Override
    public PolicyFinderResult<PolicySet> getPolicySet(IdReferenceMatch idReferenceMatch) {
        return this.lookupPolicySetByIdentifier(idReferenceMatch);
    }

    public void addReferencedPolicy(PolicyDef policyDef) {
        this.updatePolicyMap(policyDef);
    }

    public static class StdPolicyFinderException
    extends Exception {
        private static final long serialVersionUID = -8969282995787463288L;

        public StdPolicyFinderException(String msg) {
            super(msg);
        }

        public StdPolicyFinderException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

