/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Version;
import org.apache.openaz.xacml.pdp.policy.CombiningAlgorithm;
import org.apache.openaz.xacml.pdp.policy.CombiningAlgorithmFactory;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.PolicyDef;
import org.apache.openaz.xacml.pdp.policy.PolicyFinder;
import org.apache.openaz.xacml.pdp.policy.PolicyFinderFactory;
import org.apache.openaz.xacml.pdp.policy.PolicySet;
import org.apache.openaz.xacml.pdp.policy.PolicySetChild;
import org.apache.openaz.xacml.pdp.policy.Target;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicyDef;
import org.apache.openaz.xacml.pdp.std.StdPolicyFinder;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.StdVersion;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.util.FactoryException;
import org.apache.openaz.xacml.util.XACMLProperties;

public class StdPolicyFinderFactory
extends PolicyFinderFactory {
    public static final String PROP_FILE = ".file";
    public static final String PROP_URL = ".url";
    private Log logger = LogFactory.getLog(this.getClass());
    private List<PolicyDef> rootPolicies;
    private List<PolicyDef> referencedPolicies;
    private boolean needsInit = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PolicyDef loadPolicyDef(String policyId, Properties properties) {
        String propLocation = properties.getProperty(policyId + PROP_FILE);
        if (propLocation != null) {
            File fileLocation = new File(propLocation);
            if (!fileLocation.exists()) {
                this.logger.error((Object)("Policy file " + fileLocation.getAbsolutePath() + " does not exist."));
            } else if (!fileLocation.canRead()) {
                this.logger.error((Object)("Policy file " + fileLocation.getAbsolutePath() + " cannot be read."));
            } else {
                try {
                    this.logger.info((Object)("Loading policy file " + fileLocation));
                    PolicyDef policyDef2 = DOMPolicyDef.load(fileLocation);
                    if (policyDef2 != null) {
                        return policyDef2;
                    }
                }
                catch (DOMStructureException ex) {
                    this.logger.error((Object)("Error loading policy file " + fileLocation.getAbsolutePath() + ": " + ex.getMessage()), (Throwable)ex);
                    return new Policy(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                }
            }
        }
        if ((propLocation = properties.getProperty(policyId + PROP_URL)) != null) {
            URLConnection urlConnection = null;
            try {
                URL url = new URL(propLocation);
                urlConnection = url.openConnection();
                this.logger.info((Object)("Loading policy file " + url.toString()));
            }
            catch (MalformedURLException ex) {
                this.logger.error((Object)("Invalid URL " + propLocation + ": " + ex.getMessage()), (Throwable)ex);
            }
            catch (IOException ex) {
                this.logger.error((Object)("IOException opening URL " + propLocation + ": " + ex.getMessage()), (Throwable)ex);
            }
            if (urlConnection != null) {
                try (InputStream is = urlConnection.getInputStream();){
                    PolicyDef policyDef3 = DOMPolicyDef.load(is);
                    if (policyDef3 != null) {
                        PolicyDef policyDef = policyDef3;
                        return policyDef;
                    }
                }
                catch (IOException ex) {
                    this.logger.error((Object)("IOException opening URL " + propLocation + ": " + ex.getMessage()), (Throwable)ex);
                }
                catch (DOMStructureException ex) {
                    this.logger.error((Object)("Invalid Policy " + propLocation + ": " + ex.getMessage()), (Throwable)ex);
                    return new Policy(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                }
            }
        }
        this.logger.error((Object)("No known location for Policy " + policyId));
        return null;
    }

    protected List<PolicyDef> getPolicyDefs(String propertyName, Properties properties) {
        String policyIds = properties.getProperty(propertyName);
        if (policyIds == null || policyIds.length() == 0) {
            return null;
        }
        Iterable policyIdArray = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)policyIds);
        if (policyIdArray == null) {
            return null;
        }
        ArrayList<PolicyDef> listPolicyDefs = new ArrayList<PolicyDef>();
        for (String policyId : policyIdArray) {
            PolicyDef policyDef = this.loadPolicyDef(policyId, properties);
            if (policyDef == null) continue;
            listPolicyDefs.add(policyDef);
        }
        return listPolicyDefs;
    }

    protected synchronized void init(Properties properties) {
        if (this.needsInit) {
            String combiningAlgorithm = properties.getProperty("xacml.openaz.policyFinderFactory.combineRootPolicies");
            if (combiningAlgorithm != null) {
                try {
                    this.logger.info((Object)("Combining root policies with " + combiningAlgorithm));
                    CombiningAlgorithm<PolicySetChild> algorithm = CombiningAlgorithmFactory.newInstance().getPolicyCombiningAlgorithm((Identifier)new IdentifierImpl(combiningAlgorithm));
                    PolicySet root = new PolicySet();
                    root.setIdentifier((Identifier)new IdentifierImpl(UUID.randomUUID().toString()));
                    root.setVersion((Version)StdVersion.newInstance((String)"1.0"));
                    root.setTarget(new Target());
                    root.setPolicyCombiningAlgorithm(algorithm);
                    for (PolicyDef policy : this.getPolicyDefs("xacml.rootPolicies", properties)) {
                        root.addChild(policy);
                    }
                    this.rootPolicies = new ArrayList<PolicyDef>();
                    this.rootPolicies.add(root);
                }
                catch (ParseException | FactoryException e) {
                    this.logger.error((Object)("Failed to load Combining Algorithm Factory: " + e.getLocalizedMessage()));
                }
            } else {
                this.rootPolicies = this.getPolicyDefs("xacml.rootPolicies", properties);
            }
            this.referencedPolicies = this.getPolicyDefs("xacml.referencedPolicies", properties);
            this.needsInit = false;
        }
    }

    @Override
    public PolicyFinder getPolicyFinder() throws FactoryException {
        try {
            this.init(XACMLProperties.getProperties());
        }
        catch (IOException e) {
            throw new FactoryException((Throwable)e);
        }
        return new StdPolicyFinder(this.rootPolicies, this.referencedPolicies);
    }

    @Override
    public PolicyFinder getPolicyFinder(Properties properties) throws FactoryException {
        this.init(properties);
        return new StdPolicyFinder(this.rootPolicies, this.referencedPolicies);
    }
}

