/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.combiners;

import java.util.List;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.pdp.eval.Evaluatable;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.EvaluationResult;
import org.apache.openaz.xacml.pdp.policy.CombinerParameter;
import org.apache.openaz.xacml.pdp.policy.CombiningElement;
import org.apache.openaz.xacml.pdp.std.combiners.CombiningAlgorithmBase;

public class DenyOverrides<T extends Evaluatable>
extends CombiningAlgorithmBase<T> {
    public DenyOverrides(Identifier identifierIn) {
        super(identifierIn);
    }

    @Override
    public EvaluationResult combine(EvaluationContext evaluationContext, List<CombiningElement<T>> elements, List<CombinerParameter> combinerParameters) throws EvaluationException {
        boolean atLeastOnePermit = false;
        EvaluationResult combinedResult = new EvaluationResult(Decision.PERMIT);
        EvaluationResult firstIndeterminateD = null;
        EvaluationResult firstIndeterminateP = null;
        EvaluationResult firstIndeterminateDP = null;
        block8: for (CombiningElement<T> combiningElement : elements) {
            EvaluationResult evaluationResultElement = combiningElement.evaluate(evaluationContext);
            assert (evaluationResultElement != null);
            switch (evaluationResultElement.getDecision()) {
                case DENY: {
                    return evaluationResultElement;
                }
                case INDETERMINATE: 
                case INDETERMINATE_DENYPERMIT: {
                    if (firstIndeterminateDP == null) {
                        firstIndeterminateDP = evaluationResultElement;
                        continue block8;
                    }
                    firstIndeterminateDP.merge(evaluationResultElement);
                    continue block8;
                }
                case INDETERMINATE_DENY: {
                    if (firstIndeterminateD == null) {
                        firstIndeterminateD = evaluationResultElement;
                        continue block8;
                    }
                    firstIndeterminateD.merge(evaluationResultElement);
                    continue block8;
                }
                case INDETERMINATE_PERMIT: {
                    if (firstIndeterminateP == null) {
                        firstIndeterminateP = evaluationResultElement;
                        continue block8;
                    }
                    firstIndeterminateP.merge(evaluationResultElement);
                    continue block8;
                }
                case NOTAPPLICABLE: {
                    continue block8;
                }
                case PERMIT: {
                    atLeastOnePermit = true;
                    combinedResult.merge(evaluationResultElement);
                    continue block8;
                }
            }
            throw new EvaluationException("Illegal Decision: \"" + evaluationResultElement.getDecision().toString());
        }
        if (firstIndeterminateDP != null) {
            return firstIndeterminateDP;
        }
        if (firstIndeterminateD != null && (firstIndeterminateP != null || atLeastOnePermit)) {
            return new EvaluationResult(Decision.INDETERMINATE_DENYPERMIT, firstIndeterminateD.getStatus());
        }
        if (firstIndeterminateD != null) {
            return firstIndeterminateD;
        }
        if (atLeastOnePermit) {
            return combinedResult;
        }
        if (firstIndeterminateP != null) {
            return firstIndeterminateP;
        }
        return new EvaluationResult(Decision.NOTAPPLICABLE);
    }
}

