/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionHomogeneousSimple;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

public class FunctionDefinitionArithmetic<T extends Number>
extends FunctionDefinitionHomogeneousSimple<T, T> {
    private final OPERATION operation;
    private AttributeValue<BigInteger> integerResult;
    private AttributeValue<Double> doubleResult;

    public FunctionDefinitionArithmetic(Identifier idIn, DataType<T> dataTypeArgsIn, OPERATION op, int nArgs) {
        super(idIn, dataTypeArgsIn, dataTypeArgsIn, nArgs);
        this.operation = op;
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        ArrayList convertedArguments = new ArrayList();
        Status status = this.validateArguments(arguments, convertedArguments);
        if (!status.getStatusCode().equals((Object)StdStatusCode.STATUS_CODE_OK)) {
            return ExpressionResult.newError(this.getFunctionStatus(status));
        }
        ExpressionResult expressionResult = null;
        try {
            switch (this.operation) {
                case ADD: {
                    if (this.getDataType() == DataTypes.DT_INTEGER) {
                        this.integerResult = new StdAttributeValue(XACML.ID_DATATYPE_INTEGER, (Object)((BigInteger)convertedArguments.get(0)).add((BigInteger)convertedArguments.get(1)));
                        expressionResult = ExpressionResult.newSingle(this.integerResult);
                        break;
                    }
                    this.doubleResult = new StdAttributeValue(XACML.ID_DATATYPE_DOUBLE, (Object)((Double)convertedArguments.get(0) + (Double)convertedArguments.get(1)));
                    expressionResult = ExpressionResult.newSingle(this.doubleResult);
                    break;
                }
                case SUBTRACT: {
                    if (this.getDataType() == DataTypes.DT_INTEGER) {
                        this.integerResult = new StdAttributeValue(XACML.ID_DATATYPE_INTEGER, (Object)((BigInteger)convertedArguments.get(0)).subtract((BigInteger)convertedArguments.get(1)));
                        expressionResult = ExpressionResult.newSingle(this.integerResult);
                        break;
                    }
                    this.doubleResult = new StdAttributeValue(XACML.ID_DATATYPE_DOUBLE, (Object)((Double)convertedArguments.get(0) - (Double)convertedArguments.get(1)));
                    expressionResult = ExpressionResult.newSingle(this.doubleResult);
                    break;
                }
                case MULTIPLY: {
                    if (this.getDataType() == DataTypes.DT_INTEGER) {
                        this.integerResult = new StdAttributeValue(XACML.ID_DATATYPE_INTEGER, (Object)((BigInteger)convertedArguments.get(0)).multiply((BigInteger)convertedArguments.get(1)));
                        expressionResult = ExpressionResult.newSingle(this.integerResult);
                        break;
                    }
                    this.doubleResult = new StdAttributeValue(XACML.ID_DATATYPE_DOUBLE, (Object)((Double)convertedArguments.get(0) * (Double)convertedArguments.get(1)));
                    expressionResult = ExpressionResult.newSingle(this.doubleResult);
                    break;
                }
                case DIVIDE: {
                    if (this.getDataType() == DataTypes.DT_INTEGER) {
                        if (((BigInteger)convertedArguments.get(1)).equals(BigInteger.ZERO)) {
                            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Divide by 0 error: " + arguments.get(0).getValue().getValue().toString() + ", " + arguments.get(1).getValue().getValue().toString()));
                        }
                        this.integerResult = new StdAttributeValue(XACML.ID_DATATYPE_INTEGER, (Object)((BigInteger)convertedArguments.get(0)).divide((BigInteger)convertedArguments.get(1)));
                        expressionResult = ExpressionResult.newSingle(this.integerResult);
                        break;
                    }
                    if ((Double)convertedArguments.get(1) == 0.0) {
                        return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Divide by 0 error: " + arguments.get(0).getValue().getValue().toString() + ", " + arguments.get(1).getValue().getValue().toString()));
                    }
                    this.doubleResult = new StdAttributeValue(XACML.ID_DATATYPE_DOUBLE, (Object)((Double)convertedArguments.get(0) / (Double)convertedArguments.get(1)));
                    expressionResult = ExpressionResult.newSingle(this.doubleResult);
                    break;
                }
                case MOD: {
                    if (((BigInteger)convertedArguments.get(1)).equals(BigInteger.ZERO)) {
                        return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Divide by 0 error: " + arguments.get(0).getValue().getValue().toString() + ", " + arguments.get(1).getValue().getValue().toString()));
                    }
                    this.integerResult = new StdAttributeValue(XACML.ID_DATATYPE_INTEGER, (Object)((BigInteger)convertedArguments.get(0)).remainder((BigInteger)convertedArguments.get(1)));
                    expressionResult = ExpressionResult.newSingle(this.integerResult);
                    break;
                }
                case ABS: {
                    if (this.getDataType() == DataTypes.DT_INTEGER) {
                        this.integerResult = new StdAttributeValue(XACML.ID_DATATYPE_INTEGER, (Object)((BigInteger)convertedArguments.get(0)).abs());
                        expressionResult = ExpressionResult.newSingle(this.integerResult);
                        break;
                    }
                    this.doubleResult = new StdAttributeValue(XACML.ID_DATATYPE_DOUBLE, (Object)Math.abs((Double)convertedArguments.get(0)));
                    expressionResult = ExpressionResult.newSingle(this.doubleResult);
                    break;
                }
                case ROUND: {
                    this.doubleResult = new StdAttributeValue(XACML.ID_DATATYPE_DOUBLE, (Object)Math.round((Double)convertedArguments.get(0)));
                    expressionResult = ExpressionResult.newSingle(this.doubleResult);
                    break;
                }
                case FLOOR: {
                    this.doubleResult = new StdAttributeValue(XACML.ID_DATATYPE_DOUBLE, (Object)Math.floor((Double)convertedArguments.get(0)));
                    expressionResult = ExpressionResult.newSingle(this.doubleResult);
                }
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            String args = arguments.get(0).getValue().toString();
            if (arguments.size() > 1) {
                args = args + ", " + arguments.get(1).getValue().toString();
            }
            expressionResult = ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + message + " args: " + args + " " + e.getMessage()));
        }
        return expressionResult;
    }

    public static enum OPERATION {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MOD,
        ABS,
        ROUND,
        FLOOR;

    }
}

