/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionDefinition;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.datatypes.DataTypeBoolean;

public abstract class FunctionDefinitionBase<O, I>
implements FunctionDefinition {
    private Identifier id;
    private DataType<O> dataTypeReturn;
    private DataType<I> dataTypeArgs;
    private boolean returnsBag;
    protected static final ExpressionResult ER_TRUE = ExpressionResult.newSingle(DataTypeBoolean.AV_TRUE);
    protected static final ExpressionResult ER_FALSE = ExpressionResult.newSingle(DataTypeBoolean.AV_FALSE);

    protected FunctionDefinitionBase(Identifier idIn, DataType<O> returnDataTypeIn, DataType<I> argumentDataTypeIn, boolean returnsBagIn) {
        this.id = idIn;
        this.dataTypeReturn = returnDataTypeIn;
        this.dataTypeArgs = argumentDataTypeIn;
        this.returnsBag = returnsBagIn;
    }

    public String getShortFunctionId() {
        return this.getId().getUri().toString().substring(this.getId().getUri().toString().indexOf("function:"));
    }

    public String getShortDataTypeId(Identifier identifier) {
        String idString = identifier.stringValue();
        int index = idString.indexOf("#");
        if (index < 0) {
            index = idString.indexOf(":data-type:");
            if (index < 0) {
                return idString;
            }
            return idString.substring(index + 11);
        }
        return idString.substring(index + 1);
    }

    public Status getFunctionStatus(Status originalStatus) {
        return new StdStatus(originalStatus.getStatusCode(), this.getShortFunctionId() + " " + originalStatus.getStatusMessage());
    }

    @Override
    public Identifier getId() {
        return this.id;
    }

    @Override
    public Identifier getDataTypeId() {
        if (this.dataTypeReturn == null) {
            return null;
        }
        return this.dataTypeReturn.getId();
    }

    public DataType<O> getDataType() {
        return this.dataTypeReturn;
    }

    public DataType<I> getDataTypeArgs() {
        return this.dataTypeArgs;
    }

    @Override
    public boolean returnsBag() {
        return this.returnsBag;
    }
}

