/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.util.ArrayList;
import java.util.List;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionHomogeneousSimple;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

public class FunctionDefinitionComparison<I extends Comparable<I>>
extends FunctionDefinitionHomogeneousSimple<Boolean, I> {
    private OPERATION operation;

    public FunctionDefinitionComparison(Identifier idIn, DataType<I> dataTypeArgsIn, OPERATION opIn) {
        super(idIn, DataTypes.DT_BOOLEAN, dataTypeArgsIn, 2);
        this.operation = opIn;
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        int compareResult;
        ArrayList convertedArguments = new ArrayList();
        Status status = this.validateArguments(arguments, convertedArguments);
        if (!status.getStatusCode().equals((Object)StdStatusCode.STATUS_CODE_OK)) {
            return ExpressionResult.newError(this.getFunctionStatus(status));
        }
        try {
            compareResult = ((Comparable)convertedArguments.get(0)).compareTo(convertedArguments.get(1));
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + message));
        }
        switch (this.operation) {
            case GREATER_THAN: {
                if (compareResult > 0) {
                    return ER_TRUE;
                }
                return ER_FALSE;
            }
            case GREATER_THAN_EQUAL: {
                if (compareResult > -1) {
                    return ER_TRUE;
                }
                return ER_FALSE;
            }
            case LESS_THAN: {
                if (compareResult < 0) {
                    return ER_TRUE;
                }
                return ER_FALSE;
            }
            case LESS_THAN_EQUAL: {
                if (compareResult < 1) {
                    return ER_TRUE;
                }
                return ER_FALSE;
            }
        }
        return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " ENUM did not cover case of " + (Object)((Object)this.operation)));
    }

    public static enum OPERATION {
        GREATER_THAN,
        GREATER_THAN_EQUAL,
        LESS_THAN,
        LESS_THAN_EQUAL;

    }
}

