/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.util.List;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.ConvertedArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionBase;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.IDateTime;
import org.apache.openaz.xacml.std.datatypes.ISO8601Duration;

public class FunctionDefinitionDateTimeArithmetic<O extends IDateTime<O>, I extends ISO8601Duration>
extends FunctionDefinitionBase<O, I> {
    private final OPERATION operation;

    public FunctionDefinitionDateTimeArithmetic(Identifier idIn, DataType<O> dataTypeIn, DataType<I> dataTypeArgsIn, OPERATION op) {
        super(idIn, dataTypeIn, dataTypeArgsIn, false);
        this.operation = op;
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        if (arguments == null || arguments.size() != 2) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected 2 arguments, got " + (arguments == null ? "null" : Integer.valueOf(arguments.size()))));
        }
        FunctionArgument functionArgument = arguments.get(0);
        ConvertedArgument convertedArgument0 = new ConvertedArgument(functionArgument, this.getDataType(), false);
        if (!convertedArgument0.isOk()) {
            return ExpressionResult.newError(this.getFunctionStatus(convertedArgument0.getStatus()));
        }
        IDateTime idateOrig = (IDateTime)convertedArgument0.getValue();
        functionArgument = arguments.get(1);
        ConvertedArgument convertedArgument1 = new ConvertedArgument(functionArgument, this.getDataTypeArgs(), false);
        if (!convertedArgument1.isOk()) {
            return ExpressionResult.newError(this.getFunctionStatus(convertedArgument1.getStatus()));
        }
        ISO8601Duration duration = (ISO8601Duration)convertedArgument1.getValue();
        IDateTime idateResult = null;
        switch (this.operation) {
            case ADD: {
                idateResult = (IDateTime)idateOrig.add(duration);
                break;
            }
            case SUBTRACT: {
                idateResult = (IDateTime)idateOrig.sub(duration);
            }
        }
        ExpressionResult expressionResult = null;
        try {
            expressionResult = ExpressionResult.newSingle(this.getDataType().createAttributeValue((Object)idateResult));
        }
        catch (DataTypeException e) {
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + message));
        }
        return expressionResult;
    }

    public static enum OPERATION {
        ADD,
        SUBTRACT;

    }
}

