/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.util.List;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.ConvertedArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionBase;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;

public abstract class FunctionDefinitionHomogeneousSimple<O, I>
extends FunctionDefinitionBase<O, I> {
    private Integer numArgs;

    public FunctionDefinitionHomogeneousSimple(Identifier idIn, DataType<O> dataTypeReturnIn, DataType<I> dataTypeArgsIn, Integer nArgs) {
        super(idIn, dataTypeReturnIn, dataTypeArgsIn, false);
        this.numArgs = nArgs;
    }

    public Integer getNumArgs() {
        return this.numArgs;
    }

    public Status validateArguments(List<FunctionArgument> listFunctionArguments, List<I> convertedValues) {
        Status listLengthStatus = this.validateArgumentListLength(listFunctionArguments);
        if (!listLengthStatus.isOk()) {
            return listLengthStatus;
        }
        for (int i = 0; i < listFunctionArguments.size(); ++i) {
            FunctionArgument functionArgument = listFunctionArguments.get(i);
            ConvertedArgument argument = new ConvertedArgument(functionArgument, this.getDataTypeArgs(), false);
            if (!argument.isOk()) {
                StdStatus decoratedStatus = new StdStatus(argument.getStatus().getStatusCode(), argument.getStatus().getStatusMessage() + " at arg index " + i);
                return decoratedStatus;
            }
            if (convertedValues == null) continue;
            convertedValues.add(argument.getValue());
        }
        return StdStatus.STATUS_OK;
    }

    public Status validateArgumentListLength(List<FunctionArgument> listFunctionArguments) {
        if (listFunctionArguments == null && this.numArgs > 0 || listFunctionArguments != null && this.numArgs.intValue() != listFunctionArguments.size()) {
            return new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Expected " + this.numArgs + " arguments, got " + (listFunctionArguments == null ? 0 : listFunctionArguments.size()));
        }
        return StdStatus.STATUS_OK;
    }
}

