/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.util.List;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.ConvertedArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionBase;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;
import org.apache.openaz.xacml.std.datatypes.RFC822Name;

public class FunctionDefinitionRFC822NameMatch
extends FunctionDefinitionBase<Boolean, RFC822Name> {
    public FunctionDefinitionRFC822NameMatch(Identifier idIn) {
        super(idIn, DataTypes.DT_BOOLEAN, DataTypes.DT_RFC822NAME, false);
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        if (arguments == null || arguments.size() != 2) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected 2 arguments, got " + (arguments == null ? "null" : Integer.valueOf(arguments.size()))));
        }
        ConvertedArgument stringArgument = new ConvertedArgument(arguments.get(0), DataTypes.DT_STRING, false);
        if (!stringArgument.isOk()) {
            StdStatus decoratedStatus = new StdStatus(stringArgument.getStatus().getStatusCode(), stringArgument.getStatus().getStatusMessage() + " at arg index 0");
            return ExpressionResult.newError(this.getFunctionStatus((Status)decoratedStatus));
        }
        String searchTermString = (String)stringArgument.getValue();
        ConvertedArgument rfc822Argument = new ConvertedArgument(arguments.get(1), DataTypes.DT_RFC822NAME, false);
        if (!rfc822Argument.isOk()) {
            StdStatus decoratedStatus = new StdStatus(rfc822Argument.getStatus().getStatusCode(), rfc822Argument.getStatus().getStatusMessage() + " at arg index 1");
            return ExpressionResult.newError(this.getFunctionStatus((Status)decoratedStatus));
        }
        RFC822Name rfc822Name = (RFC822Name)rfc822Argument.getValue();
        String[] searchTerms = searchTermString.split("@");
        if (searchTerms.length > 2) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " String contained more than 1 '@' in '" + searchTermString + "'"));
        }
        if (searchTerms.length == 2 || searchTermString.endsWith("@")) {
            if (searchTerms[0] == null || searchTerms[0].length() == 0) {
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " String missing local part in '" + searchTermString + "'"));
            }
            if (searchTerms.length < 2 || searchTerms[1] == null || searchTerms[1].length() == 0) {
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " String missing domain part in '" + searchTermString + "'"));
            }
            if (searchTerms[0].equals(rfc822Name.getLocalName()) && searchTerms[1].toLowerCase().equals(rfc822Name.getCanonicalDomainName())) {
                return ER_TRUE;
            }
            return ER_FALSE;
        }
        searchTerms[0] = searchTerms[0].toLowerCase();
        if (searchTerms[0].charAt(0) == '.') {
            if (rfc822Name.getCanonicalDomainName().endsWith(searchTerms[0])) {
                return ER_TRUE;
            }
            return ER_FALSE;
        }
        if (rfc822Name.getCanonicalDomainName().equals(searchTerms[0])) {
            return ER_TRUE;
        }
        return ER_FALSE;
    }
}

