/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionHomogeneousSimple;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

public class FunctionDefinitionX500NameMatch
extends FunctionDefinitionHomogeneousSimple<Boolean, X500Principal> {
    public FunctionDefinitionX500NameMatch(Identifier idIn) {
        super(idIn, DataTypes.DT_BOOLEAN, DataTypes.DT_X500NAME, 2);
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        String[] searchIn;
        ArrayList convertedArguments = new ArrayList();
        Status status = this.validateArguments(arguments, convertedArguments);
        if (!status.getStatusCode().equals((Object)StdStatusCode.STATUS_CODE_OK)) {
            return ExpressionResult.newError(this.getFunctionStatus(status));
        }
        String[] searchFor = ((X500Principal)convertedArguments.get(0)).getName().split(",");
        if (searchFor.length > (searchIn = ((X500Principal)convertedArguments.get(1)).getName().split(",")).length) {
            return ER_FALSE;
        }
        for (int i = 0; i < searchFor.length; ++i) {
            String searchForTerm = searchFor[searchFor.length - i - 1];
            String searchInTerm = searchIn[searchIn.length - i - 1];
            if (searchForTerm != null && searchInTerm != null && searchForTerm.trim().equals(searchInTerm.trim())) continue;
            return ER_FALSE;
        }
        return ER_TRUE;
    }
}

