/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.RequestAttributes;
import org.apache.openaz.xacml.api.RequestAttributesReference;
import org.apache.openaz.xacml.api.RequestReference;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.api.pdp.ScopeQualifier;
import org.apache.openaz.xacml.api.pdp.ScopeResolver;
import org.apache.openaz.xacml.api.pdp.ScopeResolverException;
import org.apache.openaz.xacml.api.pdp.ScopeResolverResult;
import org.apache.openaz.xacml.std.StdMutableAttribute;
import org.apache.openaz.xacml.std.StdMutableRequest;
import org.apache.openaz.xacml.std.StdMutableRequestAttributes;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;
import org.apache.openaz.xacml.std.datatypes.XPathExpressionWrapper;
import org.w3c.dom.NodeList;

public class StdIndividualDecisionRequestGenerator {
    private static final Identifier[] idArray = new Identifier[0];
    private static final Status STATUS_NO_ATTRIBUTES = new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "No attributes");
    private static final Status STATUS_NO_XMLID = new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "No xml:id");
    private static final Status STATUS_NO_CATEGORY = new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "No category");
    private static final Status STATUS_NO_RESOURCE_ID = new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "No " + XACML3.ID_RESOURCE_RESOURCE_ID.stringValue() + " attributes");
    private Log logger = LogFactory.getLog(StdIndividualDecisionRequestGenerator.class);
    private Request originalRequest;
    private List<Request> individualDecisionRequests = new ArrayList<Request>();
    private ScopeResolver scopeResolver;

    private static StdMutableRequestAttributes removeMultipleContentSelector(RequestAttributes requestAttributes) {
        StdMutableRequestAttributes stdRequestAttributes = new StdMutableRequestAttributes();
        stdRequestAttributes.setCategory(requestAttributes.getCategory());
        stdRequestAttributes.setContentRoot(requestAttributes.getContentRoot());
        stdRequestAttributes.setXmlId(requestAttributes.getXmlId());
        for (Attribute attribute : requestAttributes.getAttributes()) {
            if (attribute.getAttributeId().equals(XACML3.ID_MULTIPLE_CONTENT_SELECTOR)) continue;
            stdRequestAttributes.add(attribute);
        }
        return stdRequestAttributes;
    }

    private void explodeOnContentSelector(List<RequestAttributes> listRequestAttributes, int listPos, StdMutableRequest requestInProgress) {
        int listSize = listRequestAttributes.size();
        while (listPos < listSize) {
            RequestAttributes requestAttributes;
            if ((requestAttributes = listRequestAttributes.get(listPos++)).hasAttributes(XACML3.ID_MULTIPLE_CONTENT_SELECTOR)) {
                Iterator<Attribute> iterAttributesMultipleContentSelector = requestAttributes.getAttributes(XACML3.ID_MULTIPLE_CONTENT_SELECTOR);
                assert (iterAttributesMultipleContentSelector != null && iterAttributesMultipleContentSelector.hasNext());
                Attribute attributeMultipleContentSelector = iterAttributesMultipleContentSelector.next();
                if (iterAttributesMultipleContentSelector.hasNext()) {
                    this.individualDecisionRequests.add(new StdMutableRequest(new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "multiple " + XACML3.ID_MULTIPLE_CONTENT_SELECTOR.stringValue() + " in category " + requestAttributes.getCategory().stringValue())));
                    return;
                }
                Iterator<AttributeValue<XPathExpressionWrapper>> iterXPathExpressions = attributeMultipleContentSelector.findValues(DataTypes.DT_XPATHEXPRESSION);
                if (iterXPathExpressions == null || !iterXPathExpressions.hasNext()) {
                    this.individualDecisionRequests.add(new StdMutableRequest(new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "no XPathExpression values in " + XACML3.ID_MULTIPLE_CONTENT_SELECTOR.stringValue() + " in category " + requestAttributes.getCategory().stringValue())));
                    return;
                }
                AttributeValue<XPathExpressionWrapper> attributeValueXPathExpression = iterXPathExpressions.next();
                if (iterXPathExpressions.hasNext()) {
                    this.individualDecisionRequests.add(new StdMutableRequest(new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "multiple XPathExpression values in " + XACML3.ID_MULTIPLE_CONTENT_SELECTOR.stringValue() + " in category " + requestAttributes.getCategory().stringValue())));
                    return;
                }
                XPathExpressionWrapper xpathExpression = attributeValueXPathExpression.getValue();
                if (xpathExpression == null) {
                    this.individualDecisionRequests.add(new StdMutableRequest(new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "null XPathExpression")));
                    return;
                }
                NodeList nodeListXPathExpressionResults = requestAttributes.getContentNodeListByXpathExpression(xpathExpression);
                if (nodeListXPathExpressionResults == null || nodeListXPathExpressionResults.getLength() == 0) {
                    this.individualDecisionRequests.add(new StdMutableRequest(new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "no matching nodes in the Content for XPathExpression " + xpathExpression.toString() + " in category " + requestAttributes.getCategory().stringValue())));
                    return;
                }
                for (int i = 0; i < nodeListXPathExpressionResults.getLength(); ++i) {
                    try {
                        StdMutableRequestAttributes requestAttributesSingleContentSelector = StdIndividualDecisionRequestGenerator.removeMultipleContentSelector(requestAttributes);
                        XPathExpressionWrapper xpathExpressionWrapperSingle = new XPathExpressionWrapper(xpathExpression.getNamespaceContext(), xpathExpression.getPath() + "[" + (i + 1) + "]");
                        StdMutableAttribute attributeContentSelector = new StdMutableAttribute(attributeMultipleContentSelector.getCategory(), XACML3.ID_CONTENT_SELECTOR, DataTypes.DT_XPATHEXPRESSION.createAttributeValue(xpathExpressionWrapperSingle), attributeMultipleContentSelector.getIssuer(), attributeMultipleContentSelector.getIncludeInResults());
                        requestAttributesSingleContentSelector.add(attributeContentSelector);
                        StdMutableRequest stdRequestSingleContentSelector = new StdMutableRequest(requestInProgress);
                        stdRequestSingleContentSelector.add(requestAttributesSingleContentSelector);
                        this.explodeOnContentSelector(listRequestAttributes, listPos, stdRequestSingleContentSelector);
                        continue;
                    }
                    catch (Exception ex) {
                        this.individualDecisionRequests.add(new StdMutableRequest(new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, ex.getMessage())));
                        return;
                    }
                }
                return;
            }
            requestInProgress.add(requestAttributes);
        }
        this.individualDecisionRequests.add(requestInProgress);
    }

    protected void processContentSelectors(Request request) {
        Iterator<RequestAttributes> iterRequestAttributes = request.getRequestAttributes().iterator();
        if (!iterRequestAttributes.hasNext()) {
            this.individualDecisionRequests.add(request);
            return;
        }
        boolean hasMultipleContentSelectors = false;
        while (!hasMultipleContentSelectors && iterRequestAttributes.hasNext()) {
            hasMultipleContentSelectors = iterRequestAttributes.next().hasAttributes(XACML3.ID_MULTIPLE_CONTENT_SELECTOR);
        }
        if (!hasMultipleContentSelectors) {
            this.individualDecisionRequests.add(request);
        } else {
            ArrayList<RequestAttributes> listRequestAttributes = new ArrayList<RequestAttributes>();
            listRequestAttributes.addAll(request.getRequestAttributes());
            StdMutableRequest stdRequestInProgress = new StdMutableRequest();
            stdRequestInProgress.setRequestDefaults(request.getRequestDefaults());
            stdRequestInProgress.setReturnPolicyIdList(request.getReturnPolicyIdList());
            this.explodeOnContentSelector(listRequestAttributes, 0, stdRequestInProgress);
        }
    }

    private static StdMutableRequest removeResources(Request request) {
        StdMutableRequest stdRequest = new StdMutableRequest(request.getStatus());
        stdRequest.setCombinedDecision(request.getCombinedDecision());
        stdRequest.setRequestDefaults(request.getRequestDefaults());
        stdRequest.setReturnPolicyIdList(request.getReturnPolicyIdList());
        Iterator<RequestAttributes> iterRequestAttributes = request.getRequestAttributes().iterator();
        if (iterRequestAttributes != null) {
            while (iterRequestAttributes.hasNext()) {
                RequestAttributes requestAttributes = iterRequestAttributes.next();
                if (requestAttributes.getCategory() != null && requestAttributes.getCategory().equals(XACML3.ID_ATTRIBUTE_CATEGORY_RESOURCE)) continue;
                stdRequest.add(requestAttributes);
            }
        }
        return stdRequest;
    }

    private static StdMutableRequestAttributes removeScopeAttributes(RequestAttributes requestAttributes) {
        StdMutableRequestAttributes stdRequestAttributes = new StdMutableRequestAttributes();
        stdRequestAttributes.setCategory(requestAttributes.getCategory());
        stdRequestAttributes.setContentRoot(requestAttributes.getContentRoot());
        stdRequestAttributes.setXmlId(requestAttributes.getXmlId());
        for (Attribute attribute : requestAttributes.getAttributes()) {
            Identifier identifierAttribute = attribute.getAttributeId();
            if (identifierAttribute.equals(XACML3.ID_RESOURCE_RESOURCE_ID) || identifierAttribute.equals(XACML3.ID_RESOURCE_SCOPE)) continue;
            stdRequestAttributes.add(attribute);
        }
        return stdRequestAttributes;
    }

    private static ScopeQualifier getScopeQualifier(RequestAttributes requestAttributes) throws ScopeResolverException {
        Iterator<Attribute> iterAttributesScope = requestAttributes.getAttributes(XACML3.ID_RESOURCE_SCOPE);
        if (iterAttributesScope == null || !iterAttributesScope.hasNext()) {
            return null;
        }
        Attribute attributeScope = iterAttributesScope.next();
        if (iterAttributesScope.hasNext()) {
            throw new ScopeResolverException("More than one " + XACML3.ID_RESOURCE_SCOPE.stringValue() + " attribute");
        }
        Iterator<AttributeValue<?>> iterAttributeValuesScope = attributeScope.getValues().iterator();
        if (!iterAttributeValuesScope.hasNext()) {
            throw new ScopeResolverException("No values for " + XACML3.ID_RESOURCE_SCOPE.stringValue() + " atribute");
        }
        ScopeQualifier scopeQualifier = null;
        while (scopeQualifier == null && iterAttributeValuesScope.hasNext()) {
            AttributeValue<?> attributeValueScope = iterAttributeValuesScope.next();
            AttributeValue attributeValueScopeString = null;
            try {
                attributeValueScopeString = DataTypes.DT_STRING.convertAttributeValue(attributeValueScope);
                if (attributeValueScopeString == null) continue;
                scopeQualifier = ScopeQualifier.getScopeQualifier((String)attributeValueScopeString.getValue());
            }
            catch (Exception exception) {}
        }
        if (scopeQualifier == null) {
            throw new ScopeResolverException("No valid values for " + XACML3.ID_RESOURCE_SCOPE.stringValue() + " attribute");
        }
        return scopeQualifier;
    }

    protected void processScopes(Request request) {
        assert (request.getStatus() == null || request.getStatus().isOk());
        if (this.scopeResolver == null) {
            this.processContentSelectors(request);
            return;
        }
        Iterator<RequestAttributes> iterRequestAttributesResource = request.getRequestAttributes(XACML3.ID_ATTRIBUTE_CATEGORY_RESOURCE);
        if (iterRequestAttributesResource == null || !iterRequestAttributesResource.hasNext()) {
            this.processContentSelectors(request);
            return;
        }
        RequestAttributes requestAttributesResource = iterRequestAttributesResource.next();
        assert (!iterRequestAttributesResource.hasNext());
        ScopeQualifier scopeQualifier = null;
        try {
            scopeQualifier = StdIndividualDecisionRequestGenerator.getScopeQualifier(requestAttributesResource);
        }
        catch (ScopeResolverException ex) {
            this.individualDecisionRequests.add(new StdMutableRequest(new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage())));
            return;
        }
        if (scopeQualifier == null) {
            this.processContentSelectors(request);
            return;
        }
        Iterator<Attribute> iterAttributesResourceId = requestAttributesResource.getAttributes(XACML3.ID_RESOURCE_RESOURCE_ID);
        if (iterAttributesResourceId == null || !iterAttributesResourceId.hasNext()) {
            this.individualDecisionRequests.add(new StdMutableRequest(STATUS_NO_RESOURCE_ID));
            return;
        }
        StdMutableRequestAttributes requestAttributesBase = StdIndividualDecisionRequestGenerator.removeScopeAttributes(requestAttributesResource);
        StdMutableRequest stdRequest = StdIndividualDecisionRequestGenerator.removeResources(request);
        boolean bAtLeastOne = false;
        while (iterAttributesResourceId.hasNext()) {
            Attribute attributeResourceId = iterAttributesResourceId.next();
            ScopeResolverResult scopeResolverResult = null;
            try {
                scopeResolverResult = this.scopeResolver.resolveScope(attributeResourceId, scopeQualifier);
            }
            catch (ScopeResolverException ex) {
                this.logger.error((Object)("ScopeResolverException resolving " + attributeResourceId.toString() + ": " + ex.getMessage()), (Throwable)ex);
            }
            if (scopeResolverResult.getStatus() != null && !scopeResolverResult.getStatus().isOk()) {
                this.individualDecisionRequests.add(new StdMutableRequest(scopeResolverResult.getStatus()));
                return;
            }
            Iterator<Attribute> iterAttributesResourceIdResolved = scopeResolverResult.getAttributes();
            if (iterAttributesResourceIdResolved == null) continue;
            while (iterAttributesResourceIdResolved.hasNext()) {
                StdMutableRequestAttributes stdRequestAttributes = new StdMutableRequestAttributes(requestAttributesBase);
                stdRequestAttributes.add(iterAttributesResourceIdResolved.next());
                StdMutableRequest stdRequestExploded = new StdMutableRequest(stdRequest);
                stdRequestExploded.add(stdRequestAttributes);
                this.processContentSelectors(stdRequestExploded);
                bAtLeastOne = true;
            }
        }
        if (!bAtLeastOne) {
            this.logger.warn((Object)"No scopes expanded.  Using original resource ids");
            iterAttributesResourceId = requestAttributesResource.getAttributes(XACML3.ID_RESOURCE_RESOURCE_ID);
            assert (iterAttributesResourceId != null);
            while (iterAttributesResourceId.hasNext()) {
                requestAttributesBase.add(iterAttributesResourceId.next());
            }
            stdRequest.add(requestAttributesBase);
            this.processContentSelectors(stdRequest);
        }
    }

    private void explodeOnCategory(Identifier[] identifiers, int pos, StdMutableRequest requestInProgress, Map<Identifier, List<RequestAttributes>> mapCategories) {
        if (pos >= identifiers.length) {
            this.processScopes(requestInProgress);
        } else {
            List<RequestAttributes> listCategoryAttributes = mapCategories.get(identifiers[pos]);
            assert (listCategoryAttributes != null && listCategoryAttributes.size() > 0);
            if (listCategoryAttributes.size() == 1) {
                requestInProgress.add(listCategoryAttributes.get(0));
                this.explodeOnCategory(identifiers, pos + 1, requestInProgress, mapCategories);
            } else {
                for (RequestAttributes requestAttributes : listCategoryAttributes) {
                    StdMutableRequest stdRequestCopy = new StdMutableRequest(requestInProgress);
                    stdRequestCopy.add(requestAttributes);
                    this.explodeOnCategory(identifiers, pos + 1, stdRequestCopy, mapCategories);
                }
            }
        }
    }

    protected void processRepeatedCategories(Request request) {
        Iterator<RequestAttributes> iterRequestAttributes = request.getRequestAttributes().iterator();
        if (iterRequestAttributes == null || !iterRequestAttributes.hasNext()) {
            this.individualDecisionRequests.add(request);
            return;
        }
        boolean bContainsMultiples = false;
        HashSet<Identifier> setCategories = new HashSet<Identifier>();
        while (iterRequestAttributes.hasNext() && !bContainsMultiples) {
            RequestAttributes requestAttributes = iterRequestAttributes.next();
            Identifier identifierCategory = requestAttributes.getCategory();
            if (identifierCategory == null) {
                this.individualDecisionRequests.add(new StdMutableRequest(STATUS_NO_CATEGORY));
                return;
            }
            if (setCategories.contains(identifierCategory)) {
                bContainsMultiples = true;
                continue;
            }
            setCategories.add(identifierCategory);
        }
        if (!bContainsMultiples) {
            this.processScopes(request);
        } else {
            iterRequestAttributes = request.getRequestAttributes().iterator();
            HashMap<Identifier, List<RequestAttributes>> mapCategories = new HashMap<Identifier, List<RequestAttributes>>();
            while (iterRequestAttributes.hasNext()) {
                RequestAttributes requestAttributes = iterRequestAttributes.next();
                Identifier identifierCategory = requestAttributes.getCategory();
                ArrayList<RequestAttributes> listRequestAttributes = (ArrayList<RequestAttributes>)mapCategories.get(identifierCategory);
                if (listRequestAttributes == null) {
                    listRequestAttributes = new ArrayList<RequestAttributes>();
                    mapCategories.put(identifierCategory, listRequestAttributes);
                }
                listRequestAttributes.add(requestAttributes);
            }
            StdMutableRequest requestRoot = new StdMutableRequest();
            requestRoot.setRequestDefaults(request.getRequestDefaults());
            requestRoot.setReturnPolicyIdList(request.getReturnPolicyIdList());
            this.explodeOnCategory(mapCategories.keySet().toArray(idArray), 0, requestRoot, mapCategories);
        }
    }

    protected Request processMultiRequest(Request requestOriginal, RequestReference requestReference) {
        Collection<RequestAttributesReference> listRequestAttributesReferences = requestReference.getAttributesReferences();
        if (listRequestAttributesReferences.size() == 0) {
            return new StdMutableRequest(STATUS_NO_ATTRIBUTES);
        }
        StdMutableRequest stdRequest = new StdMutableRequest(requestOriginal.getStatus());
        stdRequest.setRequestDefaults(requestOriginal.getRequestDefaults());
        stdRequest.setReturnPolicyIdList(requestOriginal.getReturnPolicyIdList());
        for (RequestAttributesReference requestAttributesReference : listRequestAttributesReferences) {
            String xmlId = requestAttributesReference.getReferenceId();
            if (xmlId == null) {
                return new StdMutableRequest(STATUS_NO_XMLID);
            }
            RequestAttributes requestAttributes = requestOriginal.getRequestAttributesByXmlId(xmlId);
            if (requestAttributes == null) {
                return new StdMutableRequest(new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Unresolved xml:id " + xmlId));
            }
            stdRequest.add(requestAttributes);
        }
        return stdRequest;
    }

    protected void createIndividualDecisionRequests(Request request) {
        if (request.getStatus() != null && !request.getStatus().isOk()) {
            this.individualDecisionRequests.add(request);
            return;
        }
        Iterator<RequestReference> iterRequestReferences = request.getMultiRequests().iterator();
        if (iterRequestReferences != null && iterRequestReferences.hasNext()) {
            while (iterRequestReferences.hasNext()) {
                Request requestFromReferences = this.processMultiRequest(request, iterRequestReferences.next());
                assert (requestFromReferences != null);
                if (requestFromReferences.getStatus() == null || requestFromReferences.getStatus().isOk()) {
                    this.processRepeatedCategories(requestFromReferences);
                    continue;
                }
                this.individualDecisionRequests.add(requestFromReferences);
            }
        } else {
            this.processRepeatedCategories(request);
        }
    }

    public StdIndividualDecisionRequestGenerator(ScopeResolver scopeResolverIn, Request request) {
        this.originalRequest = request;
        this.scopeResolver = scopeResolverIn;
        this.createIndividualDecisionRequests(request);
    }

    public StdIndividualDecisionRequestGenerator(Request request) {
        this(null, request);
    }

    public Request getOriginalRequest() {
        return this.originalRequest;
    }

    public Iterator<Request> getIndividualDecisionRequests() {
        return this.individualDecisionRequests.iterator();
    }
}

