/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeCategory;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.RequestAttributes;
import org.apache.openaz.xacml.api.RequestDefaults;
import org.apache.openaz.xacml.api.RequestReference;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.std.StdMutableAttributeCategory;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.util.ListUtil;
import org.apache.openaz.xacml.util.ObjUtil;

public class StdMutableRequest
implements Request {
    private static final List<RequestReference> EMPTY_REQUEST_REFERENCE_LIST = Collections.unmodifiableList(new ArrayList());
    private static final List<RequestAttributes> EMPTY_REQUEST_ATTRIBUTES_LIST = Collections.unmodifiableList(new ArrayList());
    private static final List<AttributeCategory> EMPTY_ATTRIBUTE_CATEGORY_LIST = Collections.unmodifiableList(new ArrayList());
    private Status status;
    private RequestDefaults requestDefaults;
    private boolean returnPolicyIdList;
    private boolean combinedDecision;
    private List<RequestAttributes> requestAttributes;
    private List<AttributeCategory> requestAttributesIncludeInResult = EMPTY_ATTRIBUTE_CATEGORY_LIST;
    private HashMap<Identifier, List<RequestAttributes>> requestAttributesByCategoryId = new HashMap();
    private HashMap<String, RequestAttributes> requestAttributesByXmlId = new HashMap();
    private List<RequestReference> requestReferences;

    public StdMutableRequest(Status statusIn, RequestDefaults requestDefaultsIn, boolean returnPolicyIdListIn, boolean combinedDecisionIn, Collection<RequestAttributes> listRequestAttributes, Collection<RequestReference> listRequestReferences) {
        this.status = statusIn;
        this.requestDefaults = requestDefaultsIn;
        this.returnPolicyIdList = returnPolicyIdListIn;
        this.combinedDecision = combinedDecisionIn;
        if (listRequestAttributes != null) {
            this.requestAttributes = new ArrayList<RequestAttributes>();
            for (RequestAttributes requestAttributes : listRequestAttributes) {
                this.add(requestAttributes);
            }
        } else {
            this.requestAttributes = EMPTY_REQUEST_ATTRIBUTES_LIST;
        }
        if (listRequestReferences != null) {
            this.requestReferences = new ArrayList<RequestReference>();
            this.requestReferences.addAll(listRequestReferences);
        } else {
            this.requestReferences = EMPTY_REQUEST_REFERENCE_LIST;
        }
    }

    public StdMutableRequest(RequestDefaults requestDefaultsIn, boolean returnPolicyIdListIn, boolean combinedDecisionIn, Collection<RequestAttributes> listRequestAttributes, Collection<RequestReference> listRequestReferences) {
        this(null, requestDefaultsIn, returnPolicyIdListIn, combinedDecisionIn, listRequestAttributes, listRequestReferences);
    }

    public StdMutableRequest(Request request) {
        this(request.getStatus(), request.getRequestDefaults(), request.getReturnPolicyIdList(), request.getCombinedDecision(), request.getRequestAttributes(), request.getMultiRequests());
    }

    public StdMutableRequest() {
        this(null, false, false, null, null);
    }

    public StdMutableRequest(Status statusIn) {
        this(statusIn, null, false, false, null, null);
    }

    @Override
    public RequestDefaults getRequestDefaults() {
        return this.requestDefaults;
    }

    public void setRequestDefaults(RequestDefaults requestDefaultsIn) {
        this.requestDefaults = requestDefaultsIn;
    }

    @Override
    public boolean getReturnPolicyIdList() {
        return this.returnPolicyIdList;
    }

    public void setReturnPolicyIdList(boolean returnPolicyIdListIn) {
        this.returnPolicyIdList = returnPolicyIdListIn;
    }

    @Override
    public boolean getCombinedDecision() {
        return this.combinedDecision;
    }

    public void setCombinedDecision(boolean combinedDecisionIn) {
        this.combinedDecision = combinedDecisionIn;
    }

    @Override
    public Collection<RequestAttributes> getRequestAttributes() {
        return Collections.unmodifiableCollection(this.requestAttributes);
    }

    @Override
    public Iterator<RequestAttributes> getRequestAttributes(Identifier categoryId) {
        List<RequestAttributes> listRequestAttributesForCategory = this.requestAttributesByCategoryId.get(categoryId);
        if (listRequestAttributesForCategory != null) {
            return listRequestAttributesForCategory.iterator();
        }
        return EMPTY_REQUEST_ATTRIBUTES_LIST.iterator();
    }

    public void add(RequestAttributes requestAttributesNew) {
        if (this.requestAttributes == EMPTY_REQUEST_ATTRIBUTES_LIST) {
            this.requestAttributes = new ArrayList<RequestAttributes>();
        }
        this.requestAttributes.add(requestAttributesNew);
        List<RequestAttributes> listRequestAttributesForCategoryId = this.requestAttributesByCategoryId.get(requestAttributesNew.getCategory());
        if (listRequestAttributesForCategoryId == null) {
            listRequestAttributesForCategoryId = new ArrayList<RequestAttributes>();
            this.requestAttributesByCategoryId.put(requestAttributesNew.getCategory(), listRequestAttributesForCategoryId);
        }
        listRequestAttributesForCategoryId.add(requestAttributesNew);
        if (requestAttributesNew.getXmlId() != null) {
            this.requestAttributesByXmlId.put(requestAttributesNew.getXmlId(), requestAttributesNew);
        }
        StdMutableAttributeCategory attributeCategoryIncludeInResult = null;
        for (Attribute attribute : requestAttributesNew.getAttributes()) {
            if (!attribute.getIncludeInResults()) continue;
            if (attributeCategoryIncludeInResult == null) {
                attributeCategoryIncludeInResult = new StdMutableAttributeCategory();
                attributeCategoryIncludeInResult.setCategory(requestAttributesNew.getCategory());
            }
            attributeCategoryIncludeInResult.add(attribute);
        }
        if (attributeCategoryIncludeInResult != null) {
            if (this.requestAttributesIncludeInResult == EMPTY_ATTRIBUTE_CATEGORY_LIST) {
                this.requestAttributesIncludeInResult = new ArrayList<AttributeCategory>();
            }
            this.requestAttributesIncludeInResult.add(attributeCategoryIncludeInResult);
        }
    }

    @Override
    public Collection<AttributeCategory> getRequestAttributesIncludedInResult() {
        return this.requestAttributesIncludeInResult;
    }

    @Override
    public Collection<RequestReference> getMultiRequests() {
        return Collections.unmodifiableCollection(this.requestReferences);
    }

    public void add(RequestReference requestReference) {
        if (this.requestReferences == EMPTY_REQUEST_REFERENCE_LIST) {
            this.requestReferences = new ArrayList<RequestReference>();
        }
        this.requestReferences.add(requestReference);
    }

    @Override
    public RequestAttributes getRequestAttributesByXmlId(String xmlId) {
        return this.requestAttributesByXmlId.get(xmlId);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Request)) {
            return false;
        }
        Request objRequest = (Request)obj;
        return ObjUtil.equalsAllowNull(this.getStatus(), objRequest.getStatus()) && ObjUtil.equalsAllowNull(this.getRequestDefaults(), objRequest.getRequestDefaults()) && this.getCombinedDecision() == objRequest.getCombinedDecision() && this.getReturnPolicyIdList() == objRequest.getReturnPolicyIdList() && ListUtil.equalsAllowNulls(this.getRequestAttributes(), objRequest.getRequestAttributes()) && ListUtil.equalsAllowNulls(this.getMultiRequests(), objRequest.getMultiRequests());
    }

    public int hashCode() {
        int result = 17;
        if (this.getStatus() != null) {
            result = 31 * result + this.getStatus().hashCode();
        }
        if (this.getRequestDefaults() != null) {
            result = 31 * result + this.getRequestDefaults().hashCode();
        }
        result = 31 * Boolean.valueOf(this.getCombinedDecision()).hashCode();
        result = 17 * Boolean.valueOf(this.getReturnPolicyIdList()).hashCode();
        if (this.getRequestAttributes() != null) {
            result = 31 * result + this.getRequestAttributes().hashCode();
        }
        if (this.getMultiRequests() != null) {
            result = 31 * result + this.getMultiRequests().hashCode();
        }
        return result;
    }

    public String toString() {
        Collection<RequestReference> thisRequestReferences;
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        RequestDefaults objectToDump = this.getRequestDefaults();
        if (objectToDump != null) {
            stringBuilder.append("requestDefaults=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if (needsComma) {
            stringBuilder.append(',');
        }
        stringBuilder.append("returnPolicyIdList=");
        stringBuilder.append(this.getReturnPolicyIdList());
        stringBuilder.append(",combinedDecision=");
        stringBuilder.append(this.getCombinedDecision());
        Collection<RequestAttributes> thisRequestAttributes = this.getRequestAttributes();
        if (thisRequestAttributes.size() > 0) {
            stringBuilder.append(",requestAttributes=");
            stringBuilder.append(ListUtil.toString(thisRequestAttributes));
        }
        if ((thisRequestReferences = this.getMultiRequests()).size() > 0) {
            stringBuilder.append(",multiRequests=");
            stringBuilder.append(ListUtil.toString(thisRequestReferences));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    protected void validate(Attribute attribute) {
        if (attribute.getAttributeId() == null) {
            this.setStatus(new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing AttributeId"));
            return;
        }
        Iterator<AttributeValue<?>> iterAttributeValues = attribute.getValues().iterator();
        if (!iterAttributeValues.hasNext()) {
            this.setStatus(new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing AttributeValue for Attribute " + attribute.getAttributeId().stringValue()));
            return;
        }
        while (iterAttributeValues.hasNext()) {
            AttributeValue<?> attributeValue = iterAttributeValues.next();
            if (attributeValue.getDataTypeId() == null) {
                this.setStatus(new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing DataType in AttributeValue for Attribute " + attribute.getAttributeId().stringValue()));
                return;
            }
            if (attributeValue.getValue() != null) continue;
            this.setStatus(new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing value in AttributeValue for Attribute " + attribute.getAttributeId().stringValue()));
            return;
        }
    }

    protected void validate(RequestAttributes requestAttributes) {
        if (requestAttributes.getCategory() == null) {
            this.setStatus(new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing Category"));
            return;
        }
        Iterator<Attribute> iterAttributes = requestAttributes.getAttributes().iterator();
        if (iterAttributes != null) {
            while (iterAttributes.hasNext() && this.status == null) {
                this.validate(iterAttributes.next());
            }
        }
    }

    protected void validate() {
        Iterator<RequestAttributes> iterRequestAttributes = this.getRequestAttributes().iterator();
        if (iterRequestAttributes != null && iterRequestAttributes.hasNext()) {
            while (iterRequestAttributes.hasNext() && this.status == null) {
                this.validate(iterRequestAttributes.next());
            }
        }
    }

    @Override
    public Status getStatus() {
        if (this.status == null) {
            this.validate();
        }
        return this.status;
    }

    public void setStatus(Status statusIn) {
        this.status = statusIn;
    }
}

