/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.std.datatypes.DataTypeSemanticStringBase;
import org.apache.openaz.xacml.std.datatypes.ISO8601DateTime;

public class DataTypeDateTime
extends DataTypeSemanticStringBase<ISO8601DateTime> {
    private static final DataTypeDateTime singleInstance = new DataTypeDateTime();

    private DataTypeDateTime() {
        super(XACML.ID_DATATYPE_DATETIME, ISO8601DateTime.class);
    }

    public static DataTypeDateTime newInstance() {
        return singleInstance;
    }

    @Override
    public ISO8601DateTime convert(Object source) throws DataTypeException {
        if (source == null || source instanceof ISO8601DateTime) {
            return (ISO8601DateTime)source;
        }
        if (source instanceof Calendar) {
            return ISO8601DateTime.fromCalendar((Calendar)source);
        }
        if (source instanceof Date) {
            return ISO8601DateTime.fromDate((Date)source);
        }
        String stringValue = this.convertToString(source);
        ISO8601DateTime dateTime = null;
        try {
            dateTime = ISO8601DateTime.fromISO8601DateTimeString(stringValue);
        }
        catch (ParseException ex) {
            throw new DataTypeException(this, "Failed to convert \"" + source.getClass().getCanonicalName() + "\" with value \"" + stringValue + "\" to DateTime", ex);
        }
        return dateTime;
    }
}

