/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.openaz.xacml.api.SemanticString;
import org.apache.openaz.xacml.util.StringUtils;

public class HexBinary
implements SemanticString {
    private byte[] data;

    public HexBinary(byte[] dataIn) {
        this.data = dataIn;
    }

    public static HexBinary newInstance(String stringHexBinary) throws DecoderException {
        if (stringHexBinary == null) {
            return null;
        }
        byte[] hexBytes = (byte[])new Hex().decode((Object)stringHexBinary);
        return new HexBinary(hexBytes);
    }

    public byte[] getData() {
        return this.data;
    }

    public int hashCode() {
        return this.getData() == null ? 0 : this.getData().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HexBinary)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        HexBinary hexBinaryObj = (HexBinary)obj;
        if (this.getData() == null) {
            return hexBinaryObj.getData() == null;
        }
        if (hexBinaryObj.getData() == null) {
            return false;
        }
        return Arrays.equals(this.getData(), hexBinaryObj.getData());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        byte[] thisData = this.getData();
        if (thisData != null) {
            stringBuilder.append("data=");
            stringBuilder.append(StringUtils.toString(thisData));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public String stringValue() {
        byte[] thisData = this.getData();
        return thisData == null ? null : Hex.encodeHexString((byte[])thisData);
    }
}

