/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import org.apache.openaz.xacml.std.datatypes.ISO8601Duration;

public class XPathDayTimeDuration
extends ISO8601Duration
implements Comparable<XPathDayTimeDuration> {
    private double fractionalSeconds = (double)this.getDurationSign() * ((double)(this.getDays() * 24 * 60 * 60 + this.getHours() * 60 * 60 + this.getMinutes() * 60) + this.getFractionalSecs());

    public XPathDayTimeDuration(int durationSignIn, int daysIn, int hoursIn, int minutesIn, double secondsIn) {
        super(durationSignIn, 0, 0, daysIn, hoursIn, minutesIn, secondsIn);
    }

    public double getFractionalSeconds() {
        return this.fractionalSeconds;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XPathDayTimeDuration)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.getFractionalSeconds() == ((XPathDayTimeDuration)obj).getFractionalSeconds();
    }

    public static XPathDayTimeDuration newInstance(String iso8601DurationString) throws ParseException {
        return XPathDayTimeDuration.newInstance(ISO8601Duration.newInstance(iso8601DurationString));
    }

    public static XPathDayTimeDuration newInstance(ISO8601Duration iso8601Duration) throws ParseException {
        if (iso8601Duration == null) {
            return null;
        }
        if (iso8601Duration.getYears() > 0 || iso8601Duration.getMonths() > 0) {
            throw new ParseException("Invalid XPath dayTimeDuration \"" + iso8601Duration.toString() + "\": includes years or months component", 0);
        }
        return new XPathDayTimeDuration(iso8601Duration.getDurationSign(), iso8601Duration.getDays(), iso8601Duration.getHours(), iso8601Duration.getMinutes(), iso8601Duration.getFractionalSecs());
    }

    public XPathDayTimeDuration getCanonicalDuration() {
        double fractionalSecondsLeft = Math.abs(this.getFractionalSeconds());
        int days = (int)(fractionalSecondsLeft / 86400.0);
        int hours = (int)((fractionalSecondsLeft -= (double)(days * 24 * 60 * 60)) / 3600.0);
        int minutes = (int)((fractionalSecondsLeft -= (double)(hours * 60 * 60)) / 60.0);
        return new XPathDayTimeDuration(this.getDurationSign(), days, hours, minutes, fractionalSecondsLeft -= (double)(minutes * 60));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(",factionalSeconds=");
        stringBuilder.append(this.getFractionalSecs());
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(XPathDayTimeDuration o) {
        if (o == null) {
            return 1;
        }
        return Double.compare(this.getFractionalSeconds(), o.getFractionalSeconds());
    }
}

