/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.AttributeAssignment;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.DataTypeFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.std.StdAttributeAssignment;
import org.apache.openaz.xacml.std.StdMutableAttributeAssignment;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.apache.openaz.xacml.util.FactoryException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMAttributeAssignment {
    private static final Log logger = LogFactory.getLog(DOMAttributeAssignment.class);

    protected DOMAttributeAssignment() {
    }

    public static AttributeAssignment newInstance(Node nodeAttributeAssignment) throws DOMStructureException {
        AttributeValue<?> attributeValue;
        StdMutableAttributeAssignment mutableAttributeAssignment;
        boolean bLenient;
        Element elementAttributeAssignment;
        block7: {
            elementAttributeAssignment = DOMUtil.getElement(nodeAttributeAssignment);
            bLenient = DOMProperties.isLenient();
            mutableAttributeAssignment = new StdMutableAttributeAssignment();
            mutableAttributeAssignment.setAttributeId(DOMUtil.getIdentifierAttribute((Node)elementAttributeAssignment, "AttributeId", !bLenient));
            Identifier identifierDataTypeId = DOMUtil.getIdentifierAttribute((Node)elementAttributeAssignment, "DataType", !bLenient);
            DataTypeFactory dataTypeFactory = null;
            try {
                dataTypeFactory = DataTypeFactory.newInstance();
                if (dataTypeFactory == null) {
                    throw new DOMStructureException("Failed to get DataTypeFactory");
                }
            }
            catch (FactoryException ex) {
                throw new DOMStructureException("FactoryException loading DataTypeFactory: " + ex.getMessage(), (Throwable)ex);
            }
            DataType<?> dataType = dataTypeFactory.getDataType(identifierDataTypeId);
            if (dataType == null) {
                throw new DOMStructureException((Node)elementAttributeAssignment, "Unknown dataType \"" + identifierDataTypeId.toString() + "\" in \"" + DOMUtil.getNodeLabel(elementAttributeAssignment));
            }
            attributeValue = null;
            try {
                attributeValue = dataType.createAttributeValue(elementAttributeAssignment);
            }
            catch (DataTypeException ex) {
                if (bLenient) break block7;
                throw new DOMStructureException("DataTypeException creating AttributeValue from \"" + DOMUtil.getNodeLabel(elementAttributeAssignment) + "\" contents", (Throwable)ex);
            }
        }
        if (attributeValue == null && !bLenient) {
            throw new DOMStructureException((Node)elementAttributeAssignment, "Failed to create AttributeValue from \"" + DOMUtil.getNodeLabel(elementAttributeAssignment) + "\" contents");
        }
        mutableAttributeAssignment.setAttributeValue(attributeValue);
        mutableAttributeAssignment.setCategory(DOMUtil.getIdentifierAttribute(elementAttributeAssignment, "Category"));
        mutableAttributeAssignment.setIssuer(DOMUtil.getStringAttribute(elementAttributeAssignment, "Issuer"));
        return new StdAttributeAssignment(mutableAttributeAssignment);
    }

    public static boolean repair(Node nodeAttributeAssignment) throws DOMStructureException {
        Element elementAttributeAssignment = DOMUtil.getElement(nodeAttributeAssignment);
        boolean result = false;
        result = DOMUtil.repairIdentifierAttribute(elementAttributeAssignment, "AttributeId", logger) || result;
        result = DOMUtil.repairIdentifierAttribute(elementAttributeAssignment, "DataType", logger) || result;
        DataTypeFactory dataTypeFactory = null;
        try {
            dataTypeFactory = DataTypeFactory.newInstance();
            if (dataTypeFactory == null) {
                throw new DOMStructureException("Failed to get DataTypeFactory");
            }
        }
        catch (FactoryException ex) {
            throw new DOMStructureException("FactoryException loading DataTypeFactory: " + ex.getMessage(), (Throwable)ex);
        }
        Identifier identifierDataType = DOMUtil.getIdentifierAttribute(elementAttributeAssignment, "DataType");
        DataType<?> dataType = dataTypeFactory.getDataType(identifierDataType);
        if (dataType == null) {
            logger.warn((Object)("Changing unknown DataType " + identifierDataType.stringValue() + " to " + XACML3.ID_DATATYPE_STRING.stringValue()));
            elementAttributeAssignment.setAttribute("DataType", XACML3.ID_DATATYPE_STRING.stringValue());
            result = true;
        }
        return result;
    }
}

