/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import org.apache.openaz.xacml.std.dom.DOMRequest;
import org.apache.openaz.xacml.std.dom.DOMResponse;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMDocumentRepair {
    protected boolean repairRequest(Node nodeRequest) throws DOMStructureException {
        return DOMRequest.repair(nodeRequest);
    }

    protected boolean repairResponse(Node nodeResponse) throws DOMStructureException {
        return DOMResponse.repair(nodeResponse);
    }

    public boolean repair(Document document) throws DOMStructureException, UnsupportedDocumentTypeException {
        Element firstChild = DOMUtil.getFirstChildElement(document);
        if (firstChild == null || !DOMUtil.isElement(firstChild)) {
            return false;
        }
        if (!DOMUtil.isInNamespace(firstChild, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
            throw new UnsupportedDocumentTypeException("Not a XACML document: " + DOMUtil.getNodeLabel(firstChild));
        }
        if ("Request".equals(firstChild.getLocalName())) {
            return this.repairRequest(firstChild);
        }
        if ("Response".equals(firstChild.getLocalName())) {
            return this.repairResponse(firstChild);
        }
        throw new UnsupportedDocumentTypeException("Not a XACML Request or Response: " + DOMUtil.getNodeLabel(firstChild));
    }

    public static class UnsupportedDocumentTypeException
    extends Exception {
        private static final long serialVersionUID = -1845303652188504199L;

        public UnsupportedDocumentTypeException(String message) {
            super(message);
        }

        public UnsupportedDocumentTypeException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

