/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Obligation;
import org.apache.openaz.xacml.std.StdMutableObligation;
import org.apache.openaz.xacml.std.StdObligation;
import org.apache.openaz.xacml.std.dom.DOMAttributeAssignment;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMObligation {
    private static final Log logger = LogFactory.getLog(DOMObligation.class);

    protected DOMObligation() {
    }

    public static Obligation newInstance(Node nodeObligation) throws DOMStructureException {
        int numChildren;
        Element elementObligation = DOMUtil.getElement(nodeObligation);
        boolean bLenient = DOMProperties.isLenient();
        StdMutableObligation mutableObligation = new StdMutableObligation();
        mutableObligation.setId(DOMUtil.getIdentifierAttribute((Node)elementObligation, "ObligationId", !bLenient));
        NodeList children = elementObligation.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("AttributeAssignment".equals(child.getLocalName())) {
                        mutableObligation.addAttributeAssignment(DOMAttributeAssignment.newInstance(child));
                        continue;
                    }
                    if (bLenient) continue;
                    throw DOMUtil.newUnexpectedElementException(child, nodeObligation);
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeObligation);
            }
        }
        return new StdObligation(mutableObligation);
    }

    public static boolean repair(Node nodeObligation) throws DOMStructureException {
        int numChildren;
        Element elementObligation = DOMUtil.getElement(nodeObligation);
        boolean result = false;
        result = DOMUtil.repairIdentifierAttribute(elementObligation, "ObligationId", logger) || result;
        NodeList children = elementObligation.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("AttributeAssignment".equals(child.getLocalName())) {
                        result = DOMAttributeAssignment.repair(child) || result;
                        continue;
                    }
                    logger.warn((Object)("Unexpected element " + child.getNodeName()));
                    elementObligation.removeChild(child);
                    result = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementObligation.removeChild(child);
                result = true;
            }
        }
        return result;
    }

    public static List<Obligation> newList(Node nodeObligations) throws DOMStructureException {
        int numChildren;
        Element elementObligations = DOMUtil.getElement(nodeObligations);
        boolean bLenient = DOMProperties.isLenient();
        ArrayList<Obligation> listObligations = new ArrayList<Obligation>();
        NodeList children = elementObligations.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("Obligation".equals(child.getLocalName())) {
                        listObligations.add(DOMObligation.newInstance(child));
                        continue;
                    }
                    if (bLenient) continue;
                    throw DOMUtil.newUnexpectedElementException(child, nodeObligations);
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeObligations);
            }
        }
        return listObligations;
    }

    public static boolean repairList(Node nodeObligations) throws DOMStructureException {
        int numChildren;
        Element elementObligations = DOMUtil.getElement(nodeObligations);
        boolean result = false;
        NodeList children = elementObligations.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("Obligation".equals(child.getLocalName())) {
                        result = result || DOMObligation.repair(child);
                        continue;
                    }
                    logger.warn((Object)("Unexpected element " + child.getNodeName()));
                    elementObligations.removeChild(child);
                    result = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementObligations.removeChild(child);
                result = true;
            }
        }
        return result;
    }
}

