/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.std.StdMutableRequest;
import org.apache.openaz.xacml.std.StdRequest;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMRequestAttributes;
import org.apache.openaz.xacml.std.dom.DOMRequestDefaults;
import org.apache.openaz.xacml.std.dom.DOMRequestReference;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMRequest {
    private static final Log logger = LogFactory.getLog(DOMRequest.class);

    protected DOMRequest() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Request load(String xmlString) throws DOMStructureException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));){
            Request request = DOMRequest.load(is);
            return request;
        }
        catch (IOException ex) {
            throw new DOMStructureException("Exception loading String Request: " + ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Request load(File fileRequest) throws DOMStructureException {
        try (FileInputStream fis = new FileInputStream(fileRequest);){
            Request request = DOMRequest.load(fis);
            return request;
        }
        catch (IOException ex) {
            throw new DOMStructureException("Exception loading File Request: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public static Request load(InputStream is) throws DOMStructureException {
        Request request;
        block7: {
            request = null;
            try {
                Document document = DOMUtil.loadDocument(is);
                if (document == null) {
                    throw new DOMStructureException("Null document returned");
                }
                Element rootNode = DOMUtil.getFirstChildElement(document);
                if (rootNode == null) {
                    throw new DOMStructureException("No child in document");
                }
                if (DOMUtil.isInNamespace(rootNode, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("Request".equals(rootNode.getLocalName())) {
                        request = DOMRequest.newInstance(rootNode);
                        if (request == null) {
                            throw new DOMStructureException("Failed to parse Request");
                        }
                        break block7;
                    }
                    throw DOMUtil.newUnexpectedElementException(rootNode);
                }
                throw DOMUtil.newUnexpectedElementException(rootNode);
            }
            catch (Exception ex) {
                throw new DOMStructureException("Exception loading Request: " + ex.getMessage(), (Throwable)ex);
            }
        }
        return request;
    }

    public static Request newInstance(Node nodeRequest) throws DOMStructureException {
        int numChildren;
        Element elementRequest = DOMUtil.getElement(nodeRequest);
        boolean bLenient = DOMProperties.isLenient();
        StdMutableRequest stdMutableRequest = new StdMutableRequest();
        stdMutableRequest.setReturnPolicyIdList(DOMUtil.getBooleanAttribute((Node)elementRequest, "ReturnPolicyIdList", !bLenient));
        stdMutableRequest.setCombinedDecision(DOMUtil.getBooleanAttribute((Node)elementRequest, "CombinedDecision", !bLenient));
        NodeList children = elementRequest.getChildNodes();
        boolean sawAttributes = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    String childName = child.getLocalName();
                    if ("Attributes".equals(childName)) {
                        stdMutableRequest.add(DOMRequestAttributes.newInstance(child));
                        sawAttributes = true;
                        continue;
                    }
                    if ("RequestDefaults".equals(childName)) {
                        stdMutableRequest.setRequestDefaults(DOMRequestDefaults.newInstance(child));
                        continue;
                    }
                    if ("MultiRequests".equals(childName)) {
                        int numGrandchildren;
                        NodeList grandchildren = child.getChildNodes();
                        if (grandchildren == null || (numGrandchildren = grandchildren.getLength()) <= 0) continue;
                        for (int j = 0; j < numGrandchildren; ++j) {
                            Node grandchild = grandchildren.item(j);
                            if (!DOMUtil.isElement(grandchild)) continue;
                            if (DOMUtil.isInNamespace(grandchild, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                                if ("RequestReference".equals(grandchild.getLocalName())) {
                                    stdMutableRequest.add(DOMRequestReference.newInstance(grandchild));
                                    continue;
                                }
                                if (bLenient) continue;
                                throw DOMUtil.newUnexpectedElementException(grandchild, nodeRequest);
                            }
                            if (bLenient) continue;
                            throw DOMUtil.newUnexpectedElementException(grandchild, nodeRequest);
                        }
                        continue;
                    }
                    if (bLenient) continue;
                    throw DOMUtil.newUnexpectedElementException(child, nodeRequest);
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeRequest);
            }
        }
        if (!sawAttributes && !bLenient) {
            throw DOMUtil.newMissingElementException(nodeRequest, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "Attributes");
        }
        return new StdRequest(stdMutableRequest);
    }

    public static boolean repair(Node nodeRequest) throws DOMStructureException {
        int numChildren;
        Element elementRequest = DOMUtil.getElement(nodeRequest);
        boolean result = false;
        result = DOMUtil.repairBooleanAttribute(elementRequest, "ReturnPolicyIdList", false, logger) || result;
        result = DOMUtil.repairBooleanAttribute(elementRequest, "CombinedDecision", false, logger) || result;
        NodeList children = elementRequest.getChildNodes();
        boolean sawAttributes = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    String childName = child.getLocalName();
                    if ("Attributes".equals(childName)) {
                        result = DOMRequestAttributes.repair(child) || result;
                        sawAttributes = true;
                        continue;
                    }
                    if ("RequestDefaults".equals(childName)) {
                        result = result || DOMRequestDefaults.repair(child);
                        continue;
                    }
                    if ("MultiRequests".equals(childName)) {
                        int numGrandchildren;
                        NodeList grandchildren = child.getChildNodes();
                        if (grandchildren == null || (numGrandchildren = grandchildren.getLength()) <= 0) continue;
                        for (int j = 0; j < numGrandchildren; ++j) {
                            Node grandchild = grandchildren.item(j);
                            if (!DOMUtil.isElement(grandchild)) continue;
                            if (DOMUtil.isInNamespace(grandchild, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                                if ("RequestReference".equals(grandchild.getLocalName())) {
                                    result = DOMRequestReference.repair(grandchild) || result;
                                    continue;
                                }
                                logger.warn((Object)("Unexpected element " + grandchild.getNodeName()));
                                child.removeChild(grandchild);
                                result = true;
                                continue;
                            }
                            logger.warn((Object)("Unexpected element " + grandchild.getNodeName()));
                            child.removeChild(grandchild);
                            result = true;
                        }
                        continue;
                    }
                    logger.warn((Object)("Unexpected element " + child.getNodeName()));
                    elementRequest.removeChild(child);
                    result = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementRequest.removeChild(child);
                result = true;
            }
        }
        if (!sawAttributes) {
            throw DOMUtil.newMissingElementException(nodeRequest, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "Attributes");
        }
        return result;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            for (String xmlFileName : args) {
                File fileXml = new File(xmlFileName);
                if (!fileXml.exists()) {
                    System.err.println("Input file \"" + fileXml.getAbsolutePath() + "\" does not exist.");
                    continue;
                }
                if (!fileXml.canRead()) {
                    System.err.println("Permission denied reading input file \"" + fileXml.getAbsolutePath() + "\"");
                    continue;
                }
                System.out.println(fileXml.getAbsolutePath() + ":");
                try {
                    Node nodeRequest;
                    Document documentRequest = DOMUtil.loadDocument(fileXml);
                    assert (documentRequest != null);
                    NodeList children = documentRequest.getChildNodes();
                    if (children == null || children.getLength() == 0) {
                        System.err.println("No Requests found in \"" + fileXml.getAbsolutePath() + "\"");
                        continue;
                    }
                    if (children.getLength() > 1) {
                        System.err.println("Multiple Requests found in \"" + fileXml.getAbsolutePath() + "\"");
                    }
                    if (!(nodeRequest = children.item(0)).getLocalName().equals("Request")) {
                        System.err.println("\"" + fileXml.getAbsolutePath() + "\" is not a Request");
                        continue;
                    }
                    Request domRequest = DOMRequest.newInstance(nodeRequest);
                    System.out.println(domRequest.toString());
                    System.out.println();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }
}

