/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.jaxp;

import java.text.ParseException;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.IdReferenceType;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.VersionMatch;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdIdReferenceMatch;
import org.apache.openaz.xacml.std.StdVersionMatch;

public class JaxpIdReferenceMatch
extends StdIdReferenceMatch {
    protected JaxpIdReferenceMatch(Identifier idIn, VersionMatch versionIn, VersionMatch earliestVersionIn, VersionMatch latestVersionIn) {
        super(idIn, versionIn, earliestVersionIn, latestVersionIn);
    }

    public static JaxpIdReferenceMatch newInstance(IdReferenceType idReferenceType) {
        if (idReferenceType == null) {
            throw new NullPointerException("Null IdReferenceType");
        }
        if (idReferenceType.getValue() == null) {
            throw new IllegalArgumentException("Null value for IdReferenceType");
        }
        StdVersionMatch version = null;
        StdVersionMatch earliestVersion = null;
        StdVersionMatch latestVersion = null;
        if (idReferenceType.getVersion() != null) {
            try {
                version = StdVersionMatch.newInstance(idReferenceType.getVersion());
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Invalid version");
            }
        }
        if (idReferenceType.getEarliestVersion() != null) {
            try {
                earliestVersion = StdVersionMatch.newInstance(idReferenceType.getEarliestVersion());
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Invalid earliest version");
            }
        }
        if (idReferenceType.getLatestVersion() != null) {
            try {
                latestVersion = StdVersionMatch.newInstance(idReferenceType.getLatestVersion());
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Invalid latest version");
            }
        }
        return new JaxpIdReferenceMatch(new IdentifierImpl(idReferenceType.getValue()), version, earliestVersion, latestVersion);
    }
}

