/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.jaxp;

import java.util.Iterator;
import javax.xml.bind.JAXBElement;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AdviceType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AttributesType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.IdReferenceType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.ObligationType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.ResultType;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.std.StdMutableResult;
import org.apache.openaz.xacml.std.jaxp.JaxpAdvice;
import org.apache.openaz.xacml.std.jaxp.JaxpAttributeCategory;
import org.apache.openaz.xacml.std.jaxp.JaxpIdReference;
import org.apache.openaz.xacml.std.jaxp.JaxpObligation;
import org.apache.openaz.xacml.std.jaxp.JaxpStatus;

public class JaxpResult
extends StdMutableResult {
    protected JaxpResult() {
    }

    public static JaxpResult newInstance(ResultType resultType) {
        if (resultType == null) {
            throw new NullPointerException("Null ResultType");
        }
        if (resultType.getDecision() == null) {
            throw new IllegalArgumentException("Null Decision in ResultType");
        }
        JaxpResult jaxpResult = new JaxpResult();
        switch (resultType.getDecision()) {
            case DENY: {
                jaxpResult.setDecision(Decision.DENY);
                break;
            }
            case INDETERMINATE: {
                jaxpResult.setDecision(Decision.INDETERMINATE);
                break;
            }
            case NOT_APPLICABLE: {
                jaxpResult.setDecision(Decision.NOTAPPLICABLE);
                break;
            }
            case PERMIT: {
                jaxpResult.setDecision(Decision.PERMIT);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Decision in ResultType \"" + resultType.getDecision().toString() + "\"");
            }
        }
        if (resultType.getStatus() != null) {
            jaxpResult.setStatus(JaxpStatus.newInstance(resultType.getStatus()));
        }
        if (resultType.getObligations() != null && resultType.getObligations().getObligation() != null && resultType.getObligations().getObligation().size() > 0) {
            Iterator<ObligationType> iterObligationTypes = resultType.getObligations().getObligation().iterator();
            while (iterObligationTypes.hasNext()) {
                jaxpResult.addObligation(JaxpObligation.newInstance(iterObligationTypes.next()));
            }
        }
        if (resultType.getAssociatedAdvice() != null && resultType.getAssociatedAdvice().getAdvice() != null && resultType.getAssociatedAdvice().getAdvice().size() > 0) {
            Iterator<AdviceType> iterAdviceTypes = resultType.getAssociatedAdvice().getAdvice().iterator();
            while (iterAdviceTypes.hasNext()) {
                jaxpResult.addAdvice(JaxpAdvice.newInstance(iterAdviceTypes.next()));
            }
        }
        if (resultType.getAttributes() != null && resultType.getAttributes().size() > 0) {
            Iterator<AttributesType> iterAttributesTypes = resultType.getAttributes().iterator();
            while (iterAttributesTypes.hasNext()) {
                jaxpResult.addAttributeCategory(JaxpAttributeCategory.newInstance(iterAttributesTypes.next()));
            }
        }
        if (resultType.getPolicyIdentifierList() != null && resultType.getPolicyIdentifierList().getPolicyIdReferenceOrPolicySetIdReference() != null && resultType.getPolicyIdentifierList().getPolicyIdReferenceOrPolicySetIdReference().size() > 0) {
            for (JAXBElement<IdReferenceType> jaxbElement : resultType.getPolicyIdentifierList().getPolicyIdReferenceOrPolicySetIdReference()) {
                if (jaxbElement.getName().getLocalPart().equals("PolicyIdReference")) {
                    jaxpResult.addPolicyIdentifier(JaxpIdReference.newInstance((IdReferenceType)jaxbElement.getValue()));
                    continue;
                }
                if (jaxbElement.getName().getLocalPart().equals("PolicySetIdReference")) {
                    jaxpResult.addPolicySetIdentifier(JaxpIdReference.newInstance((IdReferenceType)jaxbElement.getValue()));
                    continue;
                }
                throw new IllegalArgumentException("Unexpected IdReferenceType found \"" + jaxbElement.getName().getLocalPart() + "\"");
            }
        }
        return jaxpResult;
    }
}

