/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip.engines.csv;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.DataTypeFactory;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.pip.StdMutablePIPResponse;
import org.apache.openaz.xacml.std.pip.StdPIPResponse;
import org.apache.openaz.xacml.std.pip.engines.StdConfigurableEngine;
import org.apache.openaz.xacml.std.pip.engines.csv.CSVResolver;
import org.apache.openaz.xacml.util.AttributeUtils;
import org.apache.openaz.xacml.util.FactoryException;

public class CSVEngine
extends StdConfigurableEngine {
    protected Log logger = LogFactory.getLog(this.getClass());
    public static final long DEFAULT_MAX_FILE_SIZE_FOR_READALL = 100000000L;
    public static final String PROP_CLASSNAME = "classname";
    public static final String PROP_MAXSIZE = "maxsize";
    public static final String PROP_SOURCE = "source";
    public static final String PROP_DELIMITER = "delimiter";
    public static final String PROP_QUOTE = "quote";
    public static final String PROP_SKIP = "skip";
    public static final String PROP_RESOLVERS = "resolvers";
    public static final String PROP_RESOLVER = "resolver";
    private static DataTypeFactory dataTypeFactory = null;
    private long maximumSize = 100000000L;
    private File csvSourceFile;
    private char csvDelimiter;
    private char csvQuote;
    private int csvSkip;
    private boolean fileIsBig = false;
    private List<String[]> allLines = null;
    private List<CSVResolver> csvResolvers = new ArrayList<CSVResolver>();

    private void readCSVFileConfiguration(String id, Properties properties) throws PIPException {
        String tmpString;
        String message;
        String prefix = id + ".";
        String maxSize = properties.getProperty(prefix + PROP_MAXSIZE, Long.toString(100000000L));
        try {
            this.maximumSize = Long.parseLong(maxSize);
        }
        catch (NumberFormatException e) {
            message = this.getName() + ": The maximum size specified is NOT parseable: " + e.getLocalizedMessage();
            this.logger.error((Object)message);
            this.maximumSize = 100000000L;
        }
        String sourcePathString = properties.getProperty(prefix + PROP_SOURCE);
        if (sourcePathString == null || sourcePathString.length() == 0) {
            message = this.getName() + ": No csv.source parameter given";
            this.logger.error((Object)message);
            throw new PIPException(message);
        }
        this.csvSourceFile = new File(sourcePathString);
        if (!this.csvSourceFile.exists() || this.csvSourceFile.length() == 0L) {
            message = this.getName() + ": The csv.source '" + this.csvSourceFile.getAbsolutePath() + "' does not exist or has no content";
            this.logger.error((Object)message);
            throw new PIPException(message);
        }
        if (this.csvSourceFile.length() > this.maximumSize) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("File size is greater than max allowed (" + this.maximumSize + "): " + this.csvSourceFile.length()));
            }
            this.fileIsBig = true;
        }
        if ((tmpString = properties.getProperty(prefix + PROP_DELIMITER)) == null || tmpString.length() != 1) {
            String message2 = this.getName() + ": The csv.delimiter must exist and be exactly 1 character";
            this.logger.error((Object)message2);
            throw new PIPException(message2);
        }
        this.csvDelimiter = tmpString.charAt(0);
        tmpString = properties.getProperty(prefix + PROP_QUOTE);
        if (tmpString == null || tmpString.length() != 1) {
            String message3 = this.getName() + ": The csv.quote must exist and be exactly 1 character";
            this.logger.error((Object)message3);
            throw new PIPException(message3);
        }
        this.csvQuote = tmpString.charAt(0);
        tmpString = properties.getProperty(prefix + PROP_SKIP);
        if (tmpString == null) {
            String message4 = this.getName() + ": The csv.skip must be set";
            this.logger.error((Object)message4);
            throw new PIPException(message4);
        }
        try {
            this.csvSkip = Integer.parseInt(tmpString);
        }
        catch (NumberFormatException e) {
            String message5 = this.getName() + ": The csv.skip value of '" + tmpString + "' cannot be converted to integer";
            this.logger.error((Object)message5);
            throw new PIPException(message5);
        }
    }

    @Override
    public void configure(String id, Properties properties) throws PIPException {
        super.configure(id, properties);
        this.readCSVFileConfiguration(id, properties);
        String propResolverPrefix = id + "." + PROP_RESOLVERS;
        String stringProp = properties.getProperty(propResolverPrefix);
        if (stringProp == null || stringProp.isEmpty()) {
            this.logger.error((Object)("No '" + propResolverPrefix + "' property"));
            throw new PIPException("No '" + propResolverPrefix + "' property");
        }
        for (Object resolverId : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)stringProp)) {
            this.createResolver(id + "." + PROP_RESOLVER + "." + (String)resolverId, properties);
        }
        if (!this.fileIsBig) {
            try {
                Object resolverId;
                CSVReader csvReader = new CSVReader((Reader)new FileReader(this.csvSourceFile), this.csvDelimiter, this.csvQuote, this.csvSkip);
                resolverId = null;
                try {
                    this.allLines = csvReader.readAll();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)(id + ": All lines read from csv file, size=" + this.allLines.size()));
                    }
                }
                catch (Throwable throwable) {
                    resolverId = throwable;
                    throw throwable;
                }
                finally {
                    if (csvReader != null) {
                        if (resolverId != null) {
                            try {
                                csvReader.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)resolverId).addSuppressed(x2);
                            }
                        } else {
                            csvReader.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                String message = id + ": CSVReader unable to read csv.source '" + this.csvSourceFile.getAbsolutePath() + "': " + e;
                this.logger.error((Object)message, (Throwable)e);
                throw new PIPException(message);
            }
        }
    }

    protected void createResolver(String resolverId, Properties properties) throws PIPException {
        String propPrefix = resolverId + ".";
        String resolverClassName = properties.getProperty(propPrefix + PROP_CLASSNAME);
        if (resolverClassName == null || resolverClassName.length() == 0) {
            this.logger.error((Object)("No '" + propPrefix + PROP_CLASSNAME + "' property."));
            throw new PIPException("No '" + propPrefix + PROP_CLASSNAME + "' property.");
        }
        try {
            Class<?> resolverClass = Class.forName(resolverClassName);
            if (!CSVResolver.class.isAssignableFrom(resolverClass)) {
                this.logger.error((Object)("CSVResolver class " + propPrefix + " does not implement " + CSVResolver.class.getCanonicalName()));
                throw new PIPException("CSVResolver class " + propPrefix + " does not implement " + CSVResolver.class.getCanonicalName());
            }
            CSVResolver csvResolver = (CSVResolver)CSVResolver.class.cast(resolverClass.newInstance());
            csvResolver.configure(resolverId, properties, this.getIssuer());
            this.csvResolvers.add(csvResolver);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Exception creating CSVResolver: " + ex.getMessage()), (Throwable)ex);
            throw new PIPException("Exception creating CSVResolver", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public PIPResponse getAttributes(PIPRequest pipRequest, PIPFinder pipFinder) throws PIPException {
        if (this.csvResolvers.size() == 0) {
            throw new IllegalStateException(this.getClass().getCanonicalName() + " is not configured");
        }
        resolvers = new ArrayList<CSVResolver>();
        for (CSVResolver resolver : this.csvResolvers) {
            if (!resolver.supportRequest(pipRequest)) continue;
            resolvers.add(resolver);
        }
        if (resolvers.size() == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("does not support this pip request: " + pipRequest));
            }
            return StdPIPResponse.PIP_RESPONSE_EMPTY;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("supports this pip request: " + pipRequest));
        }
        listParameters = new ArrayList<Map<Integer, List<AttributeValue<?>>>>();
        for (CSVResolver resolver : resolvers) {
            map = resolver.getColumnParameterValues(this, pipRequest, pipFinder);
            if (map == null || map.isEmpty()) {
                this.logger.warn((Object)"Resolver could not find parameters.");
                return StdPIPResponse.PIP_RESPONSE_EMPTY;
            }
            listParameters.add(map);
        }
        mutablePIPResponse = new StdMutablePIPResponse();
        lineIndex = 0;
        csvReader = null;
        try {
            if (this.fileIsBig) {
                csvReader = new CSVReader((Reader)new FileReader(this.csvSourceFile), this.csvDelimiter, this.csvQuote, this.csvSkip);
            }
            block13: while (true) {
                line = null;
                if (this.fileIsBig) {
                    line = csvReader.readNext();
                    if (line == null) {
                        break;
                    }
                } else {
                    if (lineIndex >= this.allLines.size()) break;
                    line = this.allLines.get(lineIndex);
                    ++lineIndex;
                }
                if (!this.doesLineMatch(line, listParameters)) continue;
                i$ = resolvers.iterator();
                while (true) {
                    if (i$.hasNext()) ** break;
                    continue block13;
                    resolver = (CSVResolver)i$.next();
                    attributes = resolver.decodeResult(line);
                    if (attributes == null || attributes.size() <= 0) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("resolver returned " + attributes.size() + " attributes"));
                    }
                    mutablePIPResponse.addAttributes(attributes);
                }
                break;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning " + mutablePIPResponse.getAttributes().size() + " attributes"));
                for (Attribute attribute : mutablePIPResponse.getAttributes()) {
                    this.logger.debug((Object)(System.lineSeparator() + AttributeUtils.prettyPrint(attribute)));
                }
            }
            i$ = new StdPIPResponse(mutablePIPResponse);
            return i$;
        }
        catch (Exception e) {
            message = this.getName() + ": Error processing line: " + e;
            this.logger.error((Object)message, (Throwable)e);
            var10_15 = new StdPIPResponse(new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, e.getMessage()));
            return var10_15;
        }
        finally {
            if (csvReader != null) {
                try {
                    csvReader.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)("Close CSV Reader: " + e.getLocalizedMessage()));
                }
            }
        }
    }

    protected boolean doesLineMatch(String[] line, List<Map<Integer, List<AttributeValue<?>>>> listParameters) {
        for (Map<Integer, List<AttributeValue<?>>> map : listParameters) {
            for (Integer column : map.keySet()) {
                if (column >= line.length) {
                    return false;
                }
                String lineValue = line[column];
                if (lineValue.length() == 0) {
                    return false;
                }
                boolean foundMatch = false;
                for (AttributeValue<?> value : map.get(column)) {
                    DataType<?> dt = dataTypeFactory.getDataType(value.getDataTypeId());
                    try {
                        Object convertedValue = dt.convert(lineValue);
                        if (!convertedValue.equals(value.getValue())) continue;
                        foundMatch = true;
                        break;
                    }
                    catch (DataTypeException e) {
                        String message = column + " could not convert lineValue to " + dt.getId();
                        this.logger.error((Object)message);
                    }
                }
                if (foundMatch) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Collection<PIPRequest> attributesRequired() {
        HashSet<PIPRequest> requiredAttributes = new HashSet<PIPRequest>();
        for (CSVResolver resolver : this.csvResolvers) {
            resolver.attributesRequired(requiredAttributes);
        }
        return requiredAttributes;
    }

    @Override
    public Collection<PIPRequest> attributesProvided() {
        HashSet<PIPRequest> attributes = new HashSet<PIPRequest>();
        for (CSVResolver resolver : this.csvResolvers) {
            resolver.attributesProvided(attributes);
        }
        return attributes;
    }

    static {
        try {
            dataTypeFactory = DataTypeFactory.newInstance();
        }
        catch (FactoryException fx) {
            throw new RuntimeException(fx);
        }
    }
}

